/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.storage;

import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import reborncore.common.RebornCoreConfig;
import techreborn.blocks.storage.BlockEnergyStorage;
import techreborn.client.EGui;
import techreborn.init.ModBlocks;
import techreborn.tiles.idsu.TileInterdimensionalSU;

public class BlockInterdimensionalSU
extends BlockEnergyStorage {
    public BlockInterdimensionalSU() {
        super("IDSU", EGui.IDSU.ordinal());
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TileInterdimensionalSU();
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileInterdimensionalSU) {
            ((TileInterdimensionalSU)tile).ownerUdid = placer.getUniqueID().toString();
        }
        return this.getDefaultState();
    }

    @Override
    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(world, pos, state, placer, stack);
        TileEntity tile = world.getTileEntity(pos);
        if (tile instanceof TileInterdimensionalSU) {
            ((TileInterdimensionalSU)tile).ownerUdid = placer.getUniqueID().toString();
        }
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        if (RebornCoreConfig.wrenchRequired) {
            drops.add((Object)new ItemStack(ModBlocks.MACHINE_FRAMES, 1, 1));
        } else {
            super.getDrops(drops, world, pos, state, fortune);
        }
    }
}

