/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blocks.tier1;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import prospector.shootingstar.ShootingStar;
import prospector.shootingstar.model.ModelCompound;
import reborncore.api.IToolDrop;
import reborncore.api.ToolManager;
import reborncore.api.tile.IMachineGuiHandler;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.blocks.PropertyString;
import reborncore.common.util.ArrayUtils;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.StringUtils;
import techreborn.init.ModBlocks;
import techreborn.lib.MessageIDs;
import techreborn.tiles.tier1.TilePlayerDectector;
import techreborn.utils.TechRebornCreativeTab;

public class BlockPlayerDetector
extends BlockMachineBase {
    public static final String[] types = new String[]{"all", "others", "you"};
    static List<String> typeNamesList = Lists.newArrayList((Object[])ArrayUtils.arrayToLowercase((String[])types));
    public PropertyString TYPE;

    public BlockPlayerDetector() {
        super(true);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setDefaultState(this.getStateFromMeta(0));
        for (int i = 0; i < types.length; ++i) {
            ShootingStar.registerModel((ModelCompound)new ModelCompound("techreborn", (Block)this, i, "machines/tier1_machines", new IProperty[0]).setInvVariant("type=" + types[i]));
        }
    }

    public TileEntity createNewTileEntity(World world, int meta) {
        return new TilePlayerDectector();
    }

    public void onBlockPlacedBy(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        super.onBlockPlacedBy(worldIn, pos, state, placer, stack);
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof TilePlayerDectector) {
            ((TilePlayerDectector)tile).owenerUdid = placer.getUniqueID().toString();
        }
    }

    public boolean onBlockActivated(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        String type;
        ItemStack stack = playerIn.getHeldItem(EnumHand.MAIN_HAND);
        TileEntity tileEntity = worldIn.getTileEntity(pos);
        if (tileEntity == null) {
            return super.onBlockActivated(worldIn, pos, state, playerIn, hand, side, hitX, hitY, hitZ);
        }
        String newType = type = (String)((Object)state.getValue((IProperty)this.TYPE));
        TextFormatting color = TextFormatting.GREEN;
        if (!stack.isEmpty() && ToolManager.INSTANCE.canHandleTool(stack) && ToolManager.INSTANCE.handleTool(stack, pos, worldIn, playerIn, side, false)) {
            if (playerIn.isSneaking()) {
                if (tileEntity instanceof IToolDrop) {
                    ItemStack drop = ((IToolDrop)tileEntity).getToolDrop(playerIn);
                    if (drop == null) {
                        return false;
                    }
                    if (!drop.isEmpty()) {
                        BlockPlayerDetector.spawnAsEntity((World)worldIn, (BlockPos)pos, (ItemStack)drop);
                    }
                    if (!worldIn.isRemote) {
                        worldIn.setBlockState(pos, Blocks.AIR.getDefaultState(), 2);
                    }
                    return true;
                }
            } else {
                if (type.equals("all")) {
                    newType = "others";
                    color = TextFormatting.RED;
                } else if (type.equals("others")) {
                    newType = "you";
                    color = TextFormatting.BLUE;
                } else if (type.equals("you")) {
                    newType = "all";
                }
                worldIn.setBlockState(pos, state.withProperty((IProperty)this.TYPE, (Comparable)((Object)newType)));
            }
        }
        if (worldIn.isRemote) {
            ChatUtils.sendNoSpamMessages((int)MessageIDs.playerDetectorID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.detects", (Object[])new Object[0]) + " " + color + StringUtils.toFirstCapital((String)newType)));
        }
        return true;
    }

    protected BlockStateContainer createBlockState() {
        this.TYPE = new PropertyString("type", types);
        return new BlockStateContainer((Block)this, new IProperty[]{this.TYPE});
    }

    public IBlockState getStateFromMeta(int meta) {
        if (meta > types.length) {
            meta = 0;
        }
        return this.getBlockState().getBaseState().withProperty((IProperty)this.TYPE, (Comparable)((Object)typeNamesList.get(meta)));
    }

    public int getMetaFromState(IBlockState state) {
        return typeNamesList.indexOf(state.getValue((IProperty)this.TYPE));
    }

    public IMachineGuiHandler getGui() {
        return null;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return new ItemStack(ModBlocks.PLAYER_DETECTOR, 1, typeNamesList.indexOf(state.getValue((IProperty)this.TYPE)));
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        return Item.getItemFromBlock((Block)this);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubBlocks(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Block)this, 1, meta));
        }
    }

    public boolean canConnectRedstone(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return true;
    }

    public boolean canProvidePower(IBlockState state) {
        return true;
    }

    public int getWeakPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity entity = blockAccess.getTileEntity(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }

    public int getStrongPower(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity entity = blockAccess.getTileEntity(pos);
        if (entity instanceof TilePlayerDectector) {
            return ((TilePlayerDectector)entity).isProvidingPower() ? 15 : 0;
        }
        return 0;
    }
}

