/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import techreborn.tiles.TileChunkLoader;

public class GuiChunkLoader
extends GuiContainer {
    private static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/industrial_chunkloader.png");
    TileChunkLoader chunkloader;
    private GuiButton plusOneButton;
    private GuiButton plusTenButton;
    private GuiButton minusOneButton;
    private GuiButton minusTenButton;

    public GuiChunkLoader(EntityPlayer player, TileChunkLoader chunkLoader) {
        super((Container)chunkLoader.createContainer(player));
        this.xSize = 176;
        this.ySize = 167;
        this.chunkloader = chunkLoader;
    }

    public void initGui() {
        super.initGui();
        this.guiLeft = this.width / 2 - this.xSize / 2;
        this.guiTop = this.height / 2 - this.ySize / 2;
        this.plusOneButton = new GuiButton(0, this.guiLeft + 5, this.guiTop + 37, 40, 20, "+1");
        this.plusTenButton = new GuiButton(0, this.guiLeft + 45, this.guiTop + 37, 40, 20, "+10");
        this.minusOneButton = new GuiButton(0, this.guiLeft + 90, this.guiTop + 37, 40, 20, "-1");
        this.minusTenButton = new GuiButton(0, this.guiLeft + 130, this.guiTop + 37, 40, 20, "-10");
        this.buttonList.add(this.plusOneButton);
        this.buttonList.add(this.plusTenButton);
        this.buttonList.add(this.minusOneButton);
        this.buttonList.add(this.minusTenButton);
    }

    protected void drawGuiContainerBackgroundLayer(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        this.drawDefaultBackground();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
    }

    protected void drawGuiContainerForegroundLayer(int p_146979_1_, int p_146979_2_) {
        String name = I18n.format((String)"tile.techreborn:chunk_loader.name", (Object[])new Object[0]);
        this.fontRenderer.drawString(name, this.xSize / 2 - this.fontRenderer.getStringWidth(name) / 2, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

