/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.ClientProxy;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.TileDistillationTower;

public class GuiDistillationTower
extends GuiBase {
    public TileDistillationTower tile;

    public GuiDistillationTower(EntityPlayer player, TileDistillationTower tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        ClientProxy.multiblockRenderEvent.setMultiblock(null);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(8, 72, layer);
        this.drawSlot(35, 27, layer);
        this.drawSlot(35, 47, layer);
        this.drawOutputSlotBar(78, 36, 4, layer);
        this.builder.drawJEIButton((GuiBase)this, 158, 5, layer);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar((GuiBase)this, this.tile.getProgressScaled(100), 100, 55, 40, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        if (this.tile.getMutliBlock()) {
            this.addHologramButton(6, 4, 212, layer);
            this.builder.drawHologramButton((GuiBase)this, 6, 4, mouseX, mouseY, layer);
        } else {
            this.builder.drawMultiblockMissingBar((GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer);
            this.builder.drawHologramButton((GuiBase)this, 76, 56, mouseX, mouseY, layer);
        }
        this.builder.drawMultiEnergyBar((GuiBase)this, 9, 19, (int)this.tile.getEnergy(), (int)this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212 && GuiBase.slotConfigType == GuiBase.SlotConfigType.NONE) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                Multiblock multiblock = new Multiblock();
                IBlockState advancedCasing = ModBlocks.MACHINE_CASINGS.getDefaultState().withProperty((IProperty)BlockMachineCasing.TYPE, (Comparable)((Object)"advanced"));
                IBlockState standardCasing = ModBlocks.MACHINE_CASINGS.getDefaultState().withProperty((IProperty)BlockMachineCasing.TYPE, (Comparable)((Object)"standard"));
                this.addComponent(0, 0, 0, standardCasing, multiblock);
                this.addComponent(1, 0, 0, standardCasing, multiblock);
                this.addComponent(0, 0, 1, standardCasing, multiblock);
                this.addComponent(-1, 0, 0, standardCasing, multiblock);
                this.addComponent(0, 0, -1, standardCasing, multiblock);
                this.addComponent(-1, 0, -1, standardCasing, multiblock);
                this.addComponent(-1, 0, 1, standardCasing, multiblock);
                this.addComponent(1, 0, -1, standardCasing, multiblock);
                this.addComponent(1, 0, 1, standardCasing, multiblock);
                this.addComponent(1, 1, 0, advancedCasing, multiblock);
                this.addComponent(0, 1, 1, advancedCasing, multiblock);
                this.addComponent(-1, 1, 0, advancedCasing, multiblock);
                this.addComponent(0, 1, -1, advancedCasing, multiblock);
                this.addComponent(-1, 1, -1, advancedCasing, multiblock);
                this.addComponent(-1, 1, 1, advancedCasing, multiblock);
                this.addComponent(1, 1, -1, advancedCasing, multiblock);
                this.addComponent(1, 1, 1, advancedCasing, multiblock);
                this.addComponent(1, 2, 0, standardCasing, multiblock);
                this.addComponent(0, 2, 1, standardCasing, multiblock);
                this.addComponent(-1, 2, 0, standardCasing, multiblock);
                this.addComponent(0, 2, -1, standardCasing, multiblock);
                this.addComponent(-1, 2, -1, standardCasing, multiblock);
                this.addComponent(-1, 2, 1, standardCasing, multiblock);
                this.addComponent(1, 2, -1, standardCasing, multiblock);
                this.addComponent(1, 2, 1, standardCasing, multiblock);
                this.addComponent(0, 3, 0, advancedCasing, multiblock);
                this.addComponent(1, 3, 0, advancedCasing, multiblock);
                this.addComponent(0, 3, 1, advancedCasing, multiblock);
                this.addComponent(-1, 3, 0, advancedCasing, multiblock);
                this.addComponent(0, 3, -1, advancedCasing, multiblock);
                this.addComponent(-1, 3, -1, advancedCasing, multiblock);
                this.addComponent(-1, 3, 1, advancedCasing, multiblock);
                this.addComponent(1, 3, -1, advancedCasing, multiblock);
                this.addComponent(1, 3, 1, advancedCasing, multiblock);
                MultiblockSet set = new MultiblockSet(multiblock);
                ClientProxy.multiblockRenderEvent.setMultiblock(set);
                ClientProxy.multiblockRenderEvent.parent = this.tile.getPos();
                MultiblockRenderEvent.anchor = new BlockPos(this.tile.getPos().getX() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetX() * 2, this.tile.getPos().getY() - 1, this.tile.getPos().getZ() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetZ() * 2);
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
            }
        }
    }

    public void addComponent(int x, int y, int z, IBlockState blockState, Multiblock multiblock) {
        multiblock.addComponent(new BlockPos(x, y, z), blockState);
    }
}

