/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.awt.Color;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import org.apache.commons.lang3.tuple.Pair;
import reborncore.ClientProxy;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.gui.builder.widget.GuiButtonUpDown;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import reborncore.common.network.INetworkPacket;
import reborncore.common.network.NetworkManager;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.util.Torus;
import techreborn.init.ModBlocks;
import techreborn.packets.PacketFusionControlSize;
import techreborn.tiles.fusionReactor.TileFusionControlComputer;

public class GuiFusionReactor
extends GuiBase {
    TileFusionControlComputer tile;

    public GuiFusionReactor(EntityPlayer player, TileFusionControlComputer tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(partialTicks, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(34, 47, layer);
        this.drawSlot(126, 47, layer);
        this.drawOutputSlot(80, 47, layer);
        this.builder.drawJEIButton((GuiBase)this, 158, 5, layer);
        if (this.tile.getCoilStatus() > 0) {
            this.builder.drawHologramButton((GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar((GuiBase)this, this.tile.getProgressScaled(100), 100, 55, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawProgressBar((GuiBase)this, this.tile.getProgressScaled(100), 100, 105, 51, mouseX, mouseY, GuiBuilder.ProgressDirection.LEFT, layer);
        if (this.tile.getCoilStatus() > 0) {
            this.addHologramButton(6, 4, 212, layer);
            this.drawCentredString(this.tile.getStateString(), 20, Color.BLUE.darker().getRGB(), layer);
            if (this.tile.state == 2) {
                this.drawCentredString(PowerSystem.getLocaliszedPowerFormatted((int)((int)this.tile.getPowerChange())) + "/t", 30, Color.GREEN.darker().getRGB(), layer);
            }
        } else {
            this.builder.drawMultiblockMissingBar((GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer);
            this.builder.drawHologramButton((GuiBase)this, 76, 56, mouseX, mouseY, layer);
            Optional<Pair<Integer, Integer>> stackSize = this.getCoilStackCount();
            if (stackSize.isPresent()) {
                if ((Integer)stackSize.get().getLeft() > 0) {
                    this.drawCentredString("Required Coils: " + stackSize.get().getLeft() + "x64 +" + stackSize.get().getRight(), 25, 0xFFFFFF, layer);
                } else {
                    this.drawCentredString("Required Coils: " + stackSize.get().getRight(), 25, 0xFFFFFF, layer);
                }
            }
        }
        this.builder.drawUpDownButtons((GuiBase)this, 121, 79, layer);
        this.drawString("Size: " + this.tile.size, 83, 81, 0xFFFFFF, layer);
        this.drawString("" + this.tile.getPowerMultiplier() + "x", 10, 81, 0xFFFFFF, layer);
        this.buttonList.add(new GuiButtonUpDown(300, 121, 79, (GuiBase)this, GuiBase.Layer.FOREGROUND));
        this.buttonList.add(new GuiButtonUpDown(301, 133, 79, (GuiBase)this, GuiBase.Layer.FOREGROUND));
        this.buttonList.add(new GuiButtonUpDown(302, 145, 79, (GuiBase)this, GuiBase.Layer.FOREGROUND));
        this.buttonList.add(new GuiButtonUpDown(303, 157, 79, (GuiBase)this, GuiBase.Layer.FOREGROUND));
        this.builder.drawMultiEnergyBar((GuiBase)this, 9, 19, (int)this.tile.getEnergy(), (int)this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212 && GuiBase.slotConfigType == GuiBase.SlotConfigType.NONE) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                this.updateMultiBlockRender();
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
            }
        }
        if (button.id == 300) {
            this.sendSizeChange(5);
        } else if (button.id == 301) {
            this.sendSizeChange(1);
        } else if (button.id == 302) {
            this.sendSizeChange(-1);
        } else if (button.id == 303) {
            this.sendSizeChange(-5);
        }
    }

    private void sendSizeChange(int sizeDelta) {
        NetworkManager.sendToServer((INetworkPacket)new PacketFusionControlSize(sizeDelta, this.tile.getPos()));
        if (ClientProxy.multiblockRenderEvent.currentMultiblock != null) {
            this.updateMultiBlockRender();
        }
    }

    private void updateMultiBlockRender() {
        Multiblock multiblock = new Multiblock();
        IBlockState coil = ModBlocks.FUSION_COIL.getDefaultState();
        List coils = Torus.generate((BlockPos)new BlockPos(0, 0, 0), (int)this.tile.size);
        coils.forEach(pos -> this.addComponent(pos.getX(), pos.getY(), pos.getZ(), coil, multiblock));
        MultiblockSet set = new MultiblockSet(multiblock);
        ClientProxy.multiblockRenderEvent.setMultiblock(set);
        ClientProxy.multiblockRenderEvent.parent = this.tile.getPos();
        MultiblockRenderEvent.anchor = new BlockPos(this.tile.getPos().getX(), this.tile.getPos().getY() - 1, this.tile.getPos().getZ());
    }

    public void addComponent(int x, int y, int z, IBlockState blockState, Multiblock multiblock) {
        multiblock.addComponent(new BlockPos(x, y, z), blockState);
    }

    public Optional<Pair<Integer, Integer>> getCoilStackCount() {
        if (!Torus.TORUS_SIZE_MAP.containsKey(this.tile.size)) {
            return Optional.empty();
        }
        int count = (Integer)Torus.TORUS_SIZE_MAP.get(this.tile.size);
        return Optional.of(Pair.of((Object)(count / 64), (Object)(count % 64)));
    }
}

