/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import reborncore.ClientProxy;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.TileImplosionCompressor;

public class GuiImplosionCompressor
extends GuiBase {
    TileImplosionCompressor tile;

    public GuiImplosionCompressor(EntityPlayer player, TileImplosionCompressor tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        ClientProxy.multiblockRenderEvent.setMultiblock(null);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(8, 72, layer);
        this.drawSlot(50, 27, layer);
        this.drawSlot(50, 47, layer);
        this.drawSlot(92, 36, layer);
        this.drawSlot(110, 36, layer);
        if (this.tile.getMutliBlock()) {
            this.builder.drawHologramButton((GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
        this.builder.drawJEIButton((GuiBase)this, 158, 5, layer);
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar((GuiBase)this, this.tile.getProgressScaled(100), 100, 71, 40, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        if (this.tile.getMutliBlock()) {
            this.addHologramButton(6, 4, 212, layer);
        } else {
            this.builder.drawMultiblockMissingBar((GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer);
            this.builder.drawHologramButton((GuiBase)this, 76, 56, mouseX, mouseY, layer);
        }
        this.builder.drawMultiEnergyBar((GuiBase)this, 9, 19, (int)this.tile.getEnergy(), (int)this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212 && GuiBase.slotConfigType == GuiBase.SlotConfigType.NONE) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                Multiblock multiblock = new Multiblock();
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -4; y <= -2; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (x == 0 && y == -3 && z == 0) continue;
                            this.addComponent(x, y, z, ModBlocks.MACHINE_CASINGS.getDefaultState().withProperty((IProperty)BlockMachineCasing.TYPE, (Comparable)((Object)"reinforced")), multiblock);
                        }
                    }
                }
                MultiblockSet set = new MultiblockSet(multiblock);
                ClientProxy.multiblockRenderEvent.setMultiblock(set);
                ClientProxy.multiblockRenderEvent.parent = this.tile.getPos();
                MultiblockRenderEvent.anchor = new BlockPos(this.tile.getPos().getX(), this.tile.getPos().getY(), this.tile.getPos().getZ());
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
            }
        }
    }

    public void addComponent(int x, int y, int z, IBlockState blockState, Multiblock multiblock) {
        multiblock.addComponent(new BlockPos(x, y, z), blockState);
    }
}

