/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.io.IOException;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.ClientProxy;
import reborncore.client.gui.builder.GuiBase;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.client.multiblock.Multiblock;
import reborncore.client.multiblock.MultiblockRenderEvent;
import reborncore.client.multiblock.MultiblockSet;
import techreborn.blocks.BlockMachineCasing;
import techreborn.init.ModBlocks;
import techreborn.tiles.multiblock.TileIndustrialGrinder;

public class GuiIndustrialGrinder
extends GuiBase {
    TileIndustrialGrinder tile;

    public GuiIndustrialGrinder(EntityPlayer player, TileIndustrialGrinder tile) {
        super(player, (TileEntity)tile, tile.createContainer(player));
        this.tile = tile;
    }

    public void initGui() {
        super.initGui();
        ClientProxy.multiblockRenderEvent.setMultiblock(null);
    }

    protected void drawGuiContainerBackgroundLayer(float f, int mouseX, int mouseY) {
        super.drawGuiContainerBackgroundLayer(f, mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.BACKGROUND;
        this.drawSlot(8, 72, layer);
        this.drawSlot(34, 35, layer);
        this.drawSlot(34, 55, layer);
        this.drawSlot(84, 43, layer);
        this.drawSlot(126, 18, layer);
        this.drawSlot(126, 36, layer);
        this.drawSlot(126, 54, layer);
        this.drawSlot(126, 72, layer);
        this.builder.drawJEIButton((GuiBase)this, 158, 5, layer);
        if (this.tile.getMultiBlock()) {
            this.builder.drawHologramButton((GuiBase)this, 6, 4, mouseX, mouseY, layer);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
        GuiBase.Layer layer = GuiBase.Layer.FOREGROUND;
        this.builder.drawProgressBar((GuiBase)this, this.tile.getProgressScaled(100), 100, 105, 47, mouseX, mouseY, GuiBuilder.ProgressDirection.RIGHT, layer);
        this.builder.drawTank((GuiBase)this, 53, 25, mouseX, mouseY, this.tile.tank.getFluid(), this.tile.tank.getCapacity(), this.tile.tank.isEmpty(), layer);
        if (this.tile.getMultiBlock()) {
            this.addHologramButton(6, 4, 212, layer);
        } else {
            this.builder.drawMultiblockMissingBar((GuiBase)this, layer);
            this.addHologramButton(76, 56, 212, layer);
            this.builder.drawHologramButton((GuiBase)this, 76, 56, mouseX, mouseY, layer);
        }
        this.builder.drawMultiEnergyBar((GuiBase)this, 9, 19, (int)this.tile.getEnergy(), (int)this.tile.getMaxPower(), mouseX, mouseY, 0, layer);
    }

    public void actionPerformed(GuiButton button) throws IOException {
        super.actionPerformed(button);
        if (button.id == 212 && GuiBase.slotConfigType == GuiBase.SlotConfigType.NONE) {
            if (ClientProxy.multiblockRenderEvent.currentMultiblock == null) {
                Multiblock multiblock = new Multiblock();
                IBlockState standardCasing = ModBlocks.MACHINE_CASINGS.getDefaultState().withProperty((IProperty)BlockMachineCasing.TYPE, (Comparable)((Object)"standard"));
                IBlockState reinforcedCasing = ModBlocks.MACHINE_CASINGS.getDefaultState().withProperty((IProperty)BlockMachineCasing.TYPE, (Comparable)((Object)"reinforced"));
                this.addComponent(0, -1, 0, standardCasing, multiblock);
                this.addComponent(1, -1, 0, standardCasing, multiblock);
                this.addComponent(0, -1, 1, standardCasing, multiblock);
                this.addComponent(-1, -1, 0, standardCasing, multiblock);
                this.addComponent(0, -1, -1, standardCasing, multiblock);
                this.addComponent(-1, -1, -1, standardCasing, multiblock);
                this.addComponent(-1, -1, 1, standardCasing, multiblock);
                this.addComponent(1, -1, -1, standardCasing, multiblock);
                this.addComponent(1, -1, 1, standardCasing, multiblock);
                this.addComponent(0, 0, 0, Blocks.WATER.getDefaultState(), multiblock);
                this.addComponent(1, 0, 0, reinforcedCasing, multiblock);
                this.addComponent(0, 0, 1, reinforcedCasing, multiblock);
                this.addComponent(-1, 0, 0, reinforcedCasing, multiblock);
                this.addComponent(0, 0, -1, reinforcedCasing, multiblock);
                this.addComponent(-1, 0, -1, reinforcedCasing, multiblock);
                this.addComponent(-1, 0, 1, reinforcedCasing, multiblock);
                this.addComponent(1, 0, -1, reinforcedCasing, multiblock);
                this.addComponent(1, 0, 1, reinforcedCasing, multiblock);
                this.addComponent(0, 1, 0, standardCasing, multiblock);
                this.addComponent(0, 1, 0, standardCasing, multiblock);
                this.addComponent(1, 1, 0, standardCasing, multiblock);
                this.addComponent(0, 1, 1, standardCasing, multiblock);
                this.addComponent(-1, 1, 0, standardCasing, multiblock);
                this.addComponent(0, 1, -1, standardCasing, multiblock);
                this.addComponent(-1, 1, -1, standardCasing, multiblock);
                this.addComponent(-1, 1, 1, standardCasing, multiblock);
                this.addComponent(1, 1, -1, standardCasing, multiblock);
                this.addComponent(1, 1, 1, standardCasing, multiblock);
                MultiblockSet set = new MultiblockSet(multiblock);
                ClientProxy.multiblockRenderEvent.setMultiblock(set);
                ClientProxy.multiblockRenderEvent.parent = this.tile.getPos();
                MultiblockRenderEvent.anchor = new BlockPos(this.tile.getPos().getX() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetX() * 2, this.tile.getPos().getY() - 1, this.tile.getPos().getZ() - EnumFacing.getFront((int)this.tile.getFacingInt()).getFrontOffsetZ() * 2);
            } else {
                ClientProxy.multiblockRenderEvent.setMultiblock(null);
            }
        }
    }

    public void addComponent(int x, int y, int z, IBlockState blockState, Multiblock multiblock) {
        multiblock.addComponent(new BlockPos(x, y, z), blockState);
    }
}

