/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import reborncore.client.gui.builder.GuiBase;
import techreborn.init.ModItems;
import techreborn.tiles.tier0.TileIronFurnace;

public class GuiIronFurnace
extends GuiBase {
    public static final ResourceLocation texture = new ResourceLocation("minecraft", "textures/gui/container/furnace.png");
    TileIronFurnace furnace;

    public GuiIronFurnace(EntityPlayer player, TileIronFurnace furnace) {
        super(player, (TileEntity)furnace, furnace.createContainer(player));
        this.xSize = 176;
        this.ySize = 167;
        this.furnace = furnace;
    }

    protected void drawGuiContainerBackgroundLayer(float partialTicks, int mouseX, int mouseY) {
        this.drawDefaultBackground();
        GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.builder.drawSlotTab((GuiBase)this, this.guiLeft - 24, this.guiTop + 6, new ItemStack(ModItems.WRENCH));
        this.mc.getTextureManager().bindTexture(texture);
        int k = (this.width - this.xSize) / 2;
        int l = (this.height - this.ySize) / 2;
        this.drawTexturedModalRect(k, l, 0, 0, this.xSize, this.ySize);
        int j = 0;
        j = this.furnace.gaugeProgressScaled(24);
        if (j > 0) {
            this.drawTexturedModalRect(k + 78, l + 35, 176, 14, j + 1, 16);
        }
        if ((j = this.furnace.gaugeFuelScaled(12)) > 0) {
            this.drawTexturedModalRect(k + 57, l + 36 + 12 - j, 176, 12 - j, 14, j + 2);
        }
    }

    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        String name = I18n.format((String)"tile.techreborn.iron_furnace.name", (Object[])new Object[0]);
        this.fontRenderer.drawString(name, this.xSize / 2 - this.fontRenderer.getStringWidth(name) / 2, 6, 0x404040);
        this.fontRenderer.drawString(I18n.format((String)"container.inventory", (Object[])new Object[0]), 8, this.ySize - 96 + 2, 0x404040);
        super.drawGuiContainerForegroundLayer(mouseX, mouseY);
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        super.drawScreen(mouseX, mouseY, partialTicks);
        this.renderHoveredToolTip(mouseX, mouseY);
    }
}

