/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.gui;

import java.awt.Desktop;
import java.net.URI;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiConfirmOpenLink;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import techreborn.items.ItemTechManual;

public class GuiManual
extends GuiScreen {
    ItemTechManual manual;
    EntityPlayer player;
    private static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/manual.png");
    int guiWidth = 207;
    int guiHeight = 195;
    private static final String text1 = I18n.format((String)"techreborn.manual.wiki", (Object[])new Object[0]);
    private static final String text2 = I18n.format((String)"techreborn.manual.discord", (Object[])new Object[0]);

    public GuiManual(EntityPlayer player) {
        this.player = player;
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    public void initGui() {
        this.buttonList.add(new GuiButton(1, this.width / 2 - 30, this.height / 2 - this.guiHeight / 4 + 17, 60, 20, I18n.format((String)"techreborn.manual.wikibtn", (Object[])new Object[0])));
        this.buttonList.add(new GuiButton(2, this.width / 2 - 30, this.height / 2 + 22, 60, 20, I18n.format((String)"techreborn.manual.discordbtn", (Object[])new Object[0])));
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.drawDefaultBackground();
        this.mc.getTextureManager().bindTexture(texture);
        int centerX = this.width / 2 - this.guiWidth / 2;
        int centerY = this.height / 2 - this.guiHeight / 2;
        this.drawTexturedModalRect(centerX, centerY, 0, 0, this.guiWidth, this.guiHeight);
        this.fontRenderer.drawString(text1, this.width / 2 - this.fontRenderer.getStringWidth(text1) / 2, this.height / 2 - this.guiHeight / 4, 0x404040);
        this.fontRenderer.drawString(text2, this.width / 2 - this.fontRenderer.getStringWidth(text2) / 2, this.height / 2 + 5, 0x404040);
        super.drawScreen(mouseX, mouseY, partialTicks);
    }

    protected void actionPerformed(GuiButton button) {
        switch (button.id) {
            case 1: {
                this.mc.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://wiki.techreborn.ovh", 1, false));
                break;
            }
            case 2: {
                this.mc.displayGuiScreen((GuiScreen)new GuiConfirmOpenLink((GuiYesNoCallback)this, "http://discord.gg/0tCDWb77cvetwm0e", 2, false));
            }
        }
    }

    public void confirmClicked(boolean result, int id) {
        switch (id) {
            case 1: {
                if (result) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://wiki.techreborn.ovh"));
                    }
                    catch (Exception e) {
                        System.err.print(e);
                    }
                    break;
                }
                this.mc.displayGuiScreen((GuiScreen)this);
                break;
            }
            case 2: {
                if (result) {
                    try {
                        Desktop.getDesktop().browse(new URI("http://discord.gg/0tCDWb77cvetwm0e"));
                    }
                    catch (Exception e) {
                        System.err.print(e);
                    }
                    break;
                }
                this.mc.displayGuiScreen((GuiScreen)this);
            }
        }
    }
}

