/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.render;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.awt.Color;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ICustomModelLoader;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ItemLayerModel;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.SimpleModelState;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import techreborn.client.render.ModelHelper;
import techreborn.init.ModItems;
import techreborn.items.DynamicCell;

@SideOnly(value=Side.CLIENT)
public class ModelDynamicCell
implements IModel {
    public static final ModelDynamicCell MODEL = new ModelDynamicCell(new ResourceLocation("techreborn:items/cell_cover"), new ResourceLocation("techreborn:items/cell_empty"));
    public static final ModelResourceLocation MODEL_LOCATION = new ModelResourceLocation(new ResourceLocation("techreborn", "dynamic_cell"), "default");
    private static final float NORTH_Z_FLUID = 0.475f;
    private static final float SOUTH_Z_FLUID = 0.525f;
    private final ResourceLocation baseTexture;
    private final ResourceLocation emptyTexture;
    private final Fluid fluid;
    public static final OverrideHandler OVERRIDES = new OverrideHandler();

    public static void init() {
        ModelLoader.setCustomMeshDefinition((Item)ModItems.CELL, stack -> MODEL_LOCATION);
        ModelBakery.registerItemVariants((Item)ModItems.CELL, (ResourceLocation[])new ResourceLocation[]{MODEL_LOCATION});
        ModelLoaderRegistry.registerLoader((ICustomModelLoader)new DynamicCellLoader());
    }

    public ModelDynamicCell(ResourceLocation baseTexture, ResourceLocation emptyTexture) {
        this(baseTexture, emptyTexture, null);
    }

    public ModelDynamicCell(ResourceLocation baseTexture, ResourceLocation emptyTexture, Fluid fluid) {
        this.baseTexture = baseTexture;
        this.emptyTexture = emptyTexture;
        this.fluid = fluid;
    }

    public Collection<ResourceLocation> getDependencies() {
        return ImmutableList.of();
    }

    public Collection<ResourceLocation> getTextures() {
        return ImmutableList.of((Object)this.baseTexture, (Object)this.emptyTexture);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        ImmutableMap transformMap = PerspectiveMapWrapper.getTransforms((IModelState)state);
        TRSRTransformation transform = state.apply(Optional.empty()).orElse(TRSRTransformation.identity());
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll((Iterable)new ItemLayerModel(ImmutableList.of((Object)this.baseTexture)).bake((IModelState)transform, format, bakedTextureGetter).getQuads(null, null, 0L));
        ResourceLocation sprite = this.fluid != null ? this.fluid.getStill() : this.emptyTexture;
        int color = this.fluid != null ? this.fluid.getColor() : Color.WHITE.getRGB();
        TextureAtlasSprite fluidSprite = bakedTextureGetter.apply(sprite);
        if (this.fluid != null && fluidSprite != null) {
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)5.0f, (float)2.0f, (float)11.0f, (float)14.0f, (float)0.475f, (TextureAtlasSprite)fluidSprite, (EnumFacing)EnumFacing.NORTH, (int)color, (int)-1));
            builder.add((Object)ItemTextureQuadConverter.genQuad((VertexFormat)format, (TRSRTransformation)transform, (float)5.0f, (float)2.0f, (float)11.0f, (float)14.0f, (float)0.525f, (TextureAtlasSprite)fluidSprite, (EnumFacing)EnumFacing.SOUTH, (int)color, (int)-1));
        }
        return new BakedDynamicCell((List<BakedQuad>)builder.build(), this, bakedTextureGetter.apply(this.baseTexture), format, (ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation>)transformMap);
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public static class OverrideHandler
    extends ItemOverrideList {
        private final HashMap<String, IBakedModel> modelCache = new HashMap();
        private final Function<ResourceLocation, TextureAtlasSprite> textureGetter = location -> Minecraft.getMinecraft().getTextureMapBlocks().getAtlasSprite(location.toString());

        private OverrideHandler() {
            super((List)ImmutableList.of());
        }

        public IBakedModel handleItemState(IBakedModel originalModel, ItemStack stack, World world, EntityLivingBase entity) {
            FluidStack fluidStack = DynamicCell.getFluidHandler(stack).getFluid();
            if (fluidStack == null) {
                return originalModel;
            }
            String name = fluidStack.getFluid().getName();
            if (!this.modelCache.containsKey(name)) {
                BakedDynamicCell bakedCell = (BakedDynamicCell)originalModel;
                ModelDynamicCell model = new ModelDynamicCell(bakedCell.parent.baseTexture, bakedCell.parent.emptyTexture, fluidStack.getFluid());
                this.modelCache.put(name, model.bake((IModelState)new SimpleModelState(bakedCell.transformMap), bakedCell.format, this.textureGetter));
            }
            return this.modelCache.get(name);
        }
    }

    public static class BakedDynamicCell
    implements IBakedModel {
        private final List<BakedQuad> quads;
        private final ModelDynamicCell parent;
        private final TextureAtlasSprite particle;
        private final VertexFormat format;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap;

        public BakedDynamicCell(List<BakedQuad> quads, ModelDynamicCell parent, TextureAtlasSprite particle, VertexFormat format, ImmutableMap<ItemCameraTransforms.TransformType, TRSRTransformation> transformMap) {
            this.transformMap = transformMap;
            this.quads = quads;
            this.parent = parent;
            this.particle = particle;
            this.format = format;
        }

        public List<BakedQuad> getQuads(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
            return this.quads;
        }

        public boolean isAmbientOcclusion() {
            return true;
        }

        public boolean isGui3d() {
            return false;
        }

        public boolean isBuiltInRenderer() {
            return false;
        }

        public TextureAtlasSprite getParticleTexture() {
            return this.particle;
        }

        public ItemCameraTransforms getItemCameraTransforms() {
            return ModelHelper.DEFAULT_ITEM_TRANSFORMS;
        }

        public ItemOverrideList getOverrides() {
            return OVERRIDES;
        }
    }

    public static class DynamicCellLoader
    implements ICustomModelLoader {
        public boolean accepts(ResourceLocation modelLocation) {
            return modelLocation.getResourceDomain().equals("techreborn") && modelLocation.getResourcePath().contains("dynamic_cell");
        }

        public IModel loadModel(ResourceLocation modelLocation) throws Exception {
            return MODEL;
        }

        public void onResourceManagerReload(IResourceManager resourceManager) {
        }
    }
}

