/*
 * Decompiled with CFR 0.152.
 */
package techreborn.client.render.entitys;

import net.minecraft.block.properties.IProperty;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import techreborn.blocks.BlockNuke;
import techreborn.entities.EntityNukePrimed;
import techreborn.init.ModBlocks;

public class RenderNukePrimed
extends Render<EntityNukePrimed> {
    public RenderNukePrimed(RenderManager renderManager) {
        super(renderManager);
        this.shadowSize = 0.5f;
    }

    public void doRender(EntityNukePrimed entity, double x, double y, double z, float entityYaw, float partialTicks) {
        BlockRendererDispatcher blockrendererdispatcher = Minecraft.getMinecraft().getBlockRendererDispatcher();
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)((float)x), (float)((float)y + 0.5f), (float)((float)z));
        if ((float)entity.getFuse() - partialTicks + 1.0f < 10.0f) {
            float f = 1.0f - ((float)entity.getFuse() - partialTicks + 1.0f) / 10.0f;
            f = MathHelper.clamp((float)f, (float)0.0f, (float)1.0f);
            f *= f;
            f *= f;
            float f1 = 1.0f + f * 0.3f;
            GlStateManager.scale((float)f1, (float)f1, (float)f1);
        }
        this.bindEntityTexture((Entity)entity);
        GlStateManager.translate((float)-0.5f, (float)-0.5f, (float)0.5f);
        blockrendererdispatcher.renderBlockBrightness(ModBlocks.NUKE.getDefaultState(), entity.getBrightness());
        GlStateManager.translate((float)0.0f, (float)0.0f, (float)1.0f);
        if (entity.getFuse() / 5 % 2 == 0) {
            GlStateManager.disableLighting();
            GlStateManager.enableBlend();
            GlStateManager.blendFunc((int)770, (int)772);
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.doPolygonOffset((float)-3.0f, (float)-3.0f);
            GlStateManager.enablePolygonOffset();
            blockrendererdispatcher.renderBlockBrightness(ModBlocks.NUKE.getDefaultState().withProperty((IProperty)BlockNuke.OVERLAY, (Comparable)Boolean.valueOf(true)), 1.0f);
            GlStateManager.doPolygonOffset((float)0.0f, (float)0.0f);
            GlStateManager.disablePolygonOffset();
            GlStateManager.color((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.disableBlend();
            GlStateManager.enableLighting();
        }
        GlStateManager.popMatrix();
        super.doRender((Entity)entity, x, y, z, entityYaw, partialTicks);
    }

    protected ResourceLocation getEntityTexture(EntityNukePrimed entity) {
        return TextureMap.LOCATION_BLOCKS_TEXTURE;
    }
}

