/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.common.recipes.IRecipeInput;
import techreborn.api.recipe.BaseRecipe;

public abstract class BaseRecipeWrapper<T extends BaseRecipe>
implements IRecipeWrapper {
    protected final T baseRecipe;
    @Nonnull
    private final List<List<ItemStack>> inputs;
    @Nonnull
    private final List<List<ItemStack>> outputs;

    public BaseRecipeWrapper(T baseRecipe) {
        this.baseRecipe = baseRecipe;
        this.inputs = new ArrayList<List<ItemStack>>();
        this.outputs = new ArrayList<List<ItemStack>>();
        for (Object object : ((BaseRecipe)baseRecipe).getInputs()) {
            if (object instanceof ItemStack) {
                ItemStack stack = (ItemStack)object;
                if (((BaseRecipe)baseRecipe).useOreDic()) {
                    List<ItemStack> oreDictInputs = BaseRecipeWrapper.expandOreDict(stack);
                    this.inputs.add(oreDictInputs);
                    continue;
                }
                this.inputs.add(Collections.singletonList(stack));
                continue;
            }
            if (object instanceof String) {
                this.inputs.add((List<ItemStack>)OreDictionary.getOres((String)((String)object)));
                continue;
            }
            if (!(object instanceof IRecipeInput)) continue;
            this.inputs.add(((IRecipeInput)object).getAllStacks());
        }
        for (ItemStack itemStack : ((BaseRecipe)baseRecipe).getOutputs()) {
            if (((BaseRecipe)baseRecipe).useOreDic()) {
                List<ItemStack> oreDictInputs = BaseRecipeWrapper.expandOreDict(itemStack);
                this.outputs.add(oreDictInputs);
                continue;
            }
            this.outputs.add(Collections.singletonList(itemStack));
        }
    }

    private static List<ItemStack> expandOreDict(ItemStack itemStack) {
        int[] oreIds = OreDictionary.getOreIDs((ItemStack)itemStack);
        if (oreIds.length == 0) {
            return Collections.singletonList(itemStack);
        }
        HashSet<ItemStack> itemStackSet = new HashSet<ItemStack>();
        for (int oreId : oreIds) {
            String oreName = OreDictionary.getOreName((int)oreId);
            NonNullList ores = OreDictionary.getOres((String)oreName);
            for (ItemStack ore : ores) {
                if (ore.getCount() != itemStack.getCount()) {
                    ItemStack oreCopy = ore.copy();
                    oreCopy.setCount(itemStack.getCount());
                    itemStackSet.add(oreCopy);
                    continue;
                }
                itemStackSet.add(ore);
            }
        }
        return new ArrayList<ItemStack>(itemStackSet);
    }

    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInputLists(VanillaTypes.ITEM, this.inputs);
        ingredients.setOutputs(VanillaTypes.ITEM, ((BaseRecipe)this.baseRecipe).getOutputs());
    }

    @Nonnull
    public List<List<ItemStack>> getInputs() {
        return this.inputs;
    }

    public List<FluidStack> getFluidInputs() {
        return new ArrayList<FluidStack>();
    }

    @Nonnull
    public List<ItemStack> getOutputs() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (List<ItemStack> stackList : this.outputs) {
            stacks.addAll(stackList);
        }
        return stacks;
    }
}

