/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.centrifuge;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import net.minecraft.client.Minecraft;
import reborncore.client.guibuilder.GuiBuilder;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.api.recipe.machines.CentrifugeRecipe;
import techreborn.compat.jei.BaseRecipeWrapper;

public class CentrifugeRecipeWrapper
extends BaseRecipeWrapper<CentrifugeRecipe> {
    private final IDrawableAnimated progress;

    public CentrifugeRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull CentrifugeRecipe baseRecipe) {
        super(baseRecipe);
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        GuiBuilder.ProgressDirection right = GuiBuilder.ProgressDirection.RIGHT;
        IDrawableStatic progressStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, right.xActive, right.yActive, right.width, right.height);
        int ticksPerCycle = baseRecipe.tickTime() / 4;
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.progress.draw(minecraft, 25, 26);
        int y1 = 1;
        int y2 = 54;
        minecraft.fontRenderer.drawString(((CentrifugeRecipe)this.baseRecipe).tickTime / 20 + " seconds", recipeWidth / 2 - minecraft.fontRenderer.getStringWidth(((CentrifugeRecipe)this.baseRecipe).tickTime / 20 + " seconds") / 2 - 40, y1, 0x444444);
        minecraft.fontRenderer.drawString(PowerSystem.getLocaliszedPowerFormatted((int)(((CentrifugeRecipe)this.baseRecipe).euPerTick * ((CentrifugeRecipe)this.baseRecipe).tickTime)), recipeWidth / 2 - minecraft.fontRenderer.getStringWidth(PowerSystem.getLocaliszedPowerFormatted((int)(((CentrifugeRecipe)this.baseRecipe).euPerTick * ((CentrifugeRecipe)this.baseRecipe).tickTime))) / 2 - 40, y2, 0x444444);
    }
}

