/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.fluidReplicator;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import reborncore.client.guibuilder.GuiBuilder;
import techreborn.api.fluidreplicator.FluidReplicatorRecipe;
import techreborn.init.ModItems;

public class FluidReplicatorRecipeWrapper
implements IRecipeWrapper {
    private final FluidReplicatorRecipe recipe;
    private final IDrawableAnimated progress;

    public FluidReplicatorRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull FluidReplicatorRecipe recipe) {
        this.recipe = recipe;
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        GuiBuilder.ProgressDirection right = GuiBuilder.ProgressDirection.RIGHT;
        IDrawableStatic progressStatic = guiHelper.createDrawable(GuiBuilder.defaultTextureSheet, right.xActive, right.yActive, right.width, right.height);
        int ticksPerCycle = recipe.getTickTime();
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.ITEM, (Object)new ItemStack(ModItems.UU_MATTER, this.recipe.getInput()));
        ingredients.setOutput(VanillaTypes.FLUID, (Object)new FluidStack(this.recipe.getFluid(), 1000));
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progress.draw(minecraft, 25, 25);
    }
}

