/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.generators.fluid;

import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraftforge.fluids.FluidStack;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.api.generator.FluidGeneratorRecipe;
import techreborn.compat.jei.generators.fluid.FluidGeneratorRecipeCategory;

public class FluidGeneratorRecipeWrapper
implements IRecipeWrapper {
    private final FluidGeneratorRecipe baseRecipe;
    private final IDrawableAnimated progress;

    public FluidGeneratorRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull FluidGeneratorRecipe recipe) {
        this.baseRecipe = recipe;
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IDrawableStatic progressStatic = guiHelper.createDrawable(FluidGeneratorRecipeCategory.texture, 176, 3, 25, 14);
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, 200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        this.progress.draw(minecraft, 73, 26);
        minecraft.fontRenderer.drawString(PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)(this.baseRecipe.getEnergyPerMb() * 1000)) + " " + PowerSystem.getDisplayPower().abbreviation, 70, 13, 0x444444);
    }

    public void getIngredients(IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)new FluidStack(this.baseRecipe.getFluid(), 1000));
    }
}

