/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compat.jei.industrialSawmill;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.IJeiHelpers;
import mezz.jei.api.gui.IDrawableAnimated;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.compat.jei.BaseRecipeWrapper;

public class IndustrialSawmillRecipeWrapper
extends BaseRecipeWrapper<IndustrialSawmillRecipe> {
    public static final ResourceLocation texture = new ResourceLocation("techreborn", "textures/gui/industrial_sawmill.png");
    private final IDrawableAnimated progress;

    public IndustrialSawmillRecipeWrapper(@Nonnull IJeiHelpers jeiHelpers, @Nonnull IndustrialSawmillRecipe baseRecipe) {
        super(baseRecipe);
        IGuiHelper guiHelper = jeiHelpers.getGuiHelper();
        IDrawableStatic progressStatic = guiHelper.createDrawable(texture, 176, 14, 20, 13);
        int ticksPerCycle = baseRecipe.tickTime();
        this.progress = guiHelper.createAnimatedDrawable(progressStatic, ticksPerCycle, IDrawableAnimated.StartDirection.LEFT, false);
    }

    @Override
    public void getIngredients(@Nonnull IIngredients ingredients) {
        ingredients.setInput(VanillaTypes.FLUID, (Object)((IndustrialSawmillRecipe)this.baseRecipe).fluidStack);
        super.getIngredients(ingredients);
    }

    @Override
    @Nonnull
    public List<FluidStack> getFluidInputs() {
        if (((IndustrialSawmillRecipe)this.baseRecipe).fluidStack != null) {
            return Collections.singletonList(((IndustrialSawmillRecipe)this.baseRecipe).fluidStack);
        }
        return Collections.emptyList();
    }

    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        super.drawInfo(minecraft, recipeWidth, recipeHeight, mouseX, mouseY);
        this.progress.draw(minecraft, 48, 23);
        if (minecraft.fontRenderer != null) {
            int x = 70;
            int y = 40;
            int lineHeight = minecraft.fontRenderer.FONT_HEIGHT;
            minecraft.fontRenderer.drawString("Time: " + ((IndustrialSawmillRecipe)this.baseRecipe).tickTime / 20 + " s", x, y, 0x444444);
            minecraft.fontRenderer.drawString("Energy: " + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)((IndustrialSawmillRecipe)this.baseRecipe).euPerTick) + " " + PowerSystem.getDisplayPower().abbreviation + "/t", x, y += lineHeight, 0x444444);
        }
    }
}

