/*
 * Decompiled with CFR 0.152.
 */
package techreborn.dispenser;

import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockDispenser;
import net.minecraft.block.properties.IProperty;
import net.minecraft.dispenser.BehaviorDefaultDispenseItem;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IPosition;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntityDispenser;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.api.Reference;

@RebornRegistry(modID="techreborn")
public class BehaviorDispenseScrapbox
extends BehaviorDefaultDispenseItem {
    @ConfigRegistry(config="misc", category="general", key="DispenserScrapbox", comment="Dispensers will open scrapboxes")
    public static boolean dispenseScrapboxes = true;

    protected ItemStack dispenseStack(IBlockSource source, ItemStack stack) {
        if (dispenseScrapboxes) {
            List scrapboxRecipeList = RecipeHandler.getRecipeClassFromName((String)Reference.SCRAPBOX_RECIPE);
            int random = new Random().nextInt(scrapboxRecipeList.size());
            ItemStack out = ((IBaseRecipeType)scrapboxRecipeList.get(random)).getOutput(0);
            stack.splitStack(1);
            TileEntityDispenser tile = (TileEntityDispenser)source.getBlockTileEntity();
            EnumFacing enumfacing = (EnumFacing)tile.getWorld().getBlockState(new BlockPos(source.getX(), source.getY(), source.getZ())).getValue((IProperty)BlockDispenser.FACING);
            IPosition iposition = BlockDispenser.getDispensePosition((IBlockSource)source);
            BehaviorDispenseScrapbox.doDispense((World)source.getWorld(), (ItemStack)out, (int)6, (EnumFacing)enumfacing, (IPosition)iposition);
        }
        return stack;
    }
}

