/*
 * Decompiled with CFR 0.152.
 */
package techreborn.entities;

import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.common.explosion.RebornExplosion;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;

@RebornRegistry(modID="techreborn")
public class EntityNukePrimed
extends EntityTNTPrimed {
    @ConfigRegistry(config="misc", category="nuke", key="fusetime", comment="Nuke fuse time (ticks)")
    public static int fuseTime = 400;
    @ConfigRegistry(config="misc", category="nuke", key="radius", comment="Nuke explision radius")
    public static int radius = 40;
    @ConfigRegistry(config="misc", category="nuke", key="enabled", comment="Should the nuke explode, set to false to prevent block damage")
    public static boolean enabled = true;

    public EntityNukePrimed(World world) {
        super(world);
        this.setFuse(fuseTime);
    }

    public EntityNukePrimed(World world, double x, double y, double z, EntityLivingBase tntPlacedBy) {
        super(world, x, y, z, tntPlacedBy);
        this.setFuse(fuseTime);
    }

    public void onUpdate() {
        this.prevPosX = this.posX;
        this.prevPosY = this.posY;
        this.prevPosZ = this.posZ;
        if (!this.hasNoGravity()) {
            this.motionY -= (double)0.04f;
        }
        this.move(MoverType.SELF, this.motionX, this.motionY, this.motionZ);
        this.motionX *= (double)0.98f;
        this.motionY *= (double)0.98f;
        this.motionZ *= (double)0.98f;
        if (this.onGround) {
            this.motionX *= (double)0.7f;
            this.motionZ *= (double)0.7f;
            this.motionY *= -0.5;
        }
        this.setFuse(this.getFuse() - 1);
        if (this.getFuse() <= 0) {
            this.setDead();
            if (!this.world.isRemote) {
                this.explodeNuke();
            }
        } else {
            this.handleWaterMovement();
            this.world.spawnParticle(EnumParticleTypes.SMOKE_NORMAL, this.posX, this.posY + 0.5, this.posZ, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void explodeNuke() {
        if (!enabled) {
            return;
        }
        RebornExplosion nukeExplosion = new RebornExplosion(new BlockPos(this.posX, this.posY, this.posZ), this.world, radius);
        nukeExplosion.setLivingBase(this.getTntPlacedBy());
        nukeExplosion.explode();
    }
}

