/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import reborncore.api.IListInfoProvider;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.StringUtils;
import techreborn.Core;

public class StackToolTipEvent {
    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void handleItemTooltipEvent(ItemTooltipEvent event) {
        if (event.getEntityPlayer() == null) {
            return;
        }
        Item item = event.getItemStack().getItem();
        List tooltip = event.getToolTip();
        if (item instanceof IEnergyItemInfo) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(event.getItemStack());
            tooltip.add(1, TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)(capEnergy.getEnergyStored() / RebornCoreConfig.euPerFU)) + "/" + PowerSystem.getLocaliszedPowerFormattedNoSuffix((int)(capEnergy.getMaxEnergyStored() / RebornCoreConfig.euPerFU)) + " " + PowerSystem.getDisplayPower().abbreviation);
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                int percentage = this.percentage(capEnergy.getMaxEnergyStored(), capEnergy.getEnergyStored());
                tooltip.add(2, StringUtils.getPercentageColour((int)percentage) + "" + percentage + "%" + TextFormatting.GRAY + " Charged");
                tooltip.add(3, TextFormatting.GRAY + "I/O Rate: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)((int)((IEnergyItemInfo)item).getMaxTransfer(event.getItemStack()))));
            }
        } else {
            try {
                TileEntity tile;
                Block block = Block.getBlockFromItem((Item)item);
                if (block == null) {
                    return;
                }
                if (!block.getRegistryName().getResourceDomain().contains("techreborn")) {
                    return;
                }
                if ((block instanceof BlockContainer || block instanceof ITileEntityProvider) && (tile = block.createTileEntity((World)Minecraft.getMinecraft().world, block.getStateFromMeta(event.getItemStack().getItemDamage()))) instanceof IListInfoProvider) {
                    ((IListInfoProvider)tile).addInfo(tooltip, false);
                }
            }
            catch (NullPointerException e) {
                Core.logHelper.debug((Object)("Failed to tick info for " + event.getItemStack().getDisplayName()));
            }
        }
    }

    private int percentage(int MaxValue, int CurrentValue) {
        if (CurrentValue == 0) {
            return 0;
        }
        return (int)((float)CurrentValue * 100.0f / (float)MaxValue);
    }
}

