/*
 * Decompiled with CFR 0.152.
 */
package techreborn.events;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import reborncore.common.util.ItemUtils;
import techreborn.init.ModItems;

public class TRRecipeHandler {
    private static List<IForgeRegistryEntry> hiddenEntrys = new ArrayList<IForgeRegistryEntry>();

    public static void hideEntry(IForgeRegistryEntry<?> entry) {
        hiddenEntrys.add(entry);
    }

    @SubscribeEvent
    public void pickupEvent(EntityItemPickupEvent entityItemPickupEvent) {
        if (entityItemPickupEvent.getEntityPlayer() instanceof FakePlayer) {
            return;
        }
        if (entityItemPickupEvent.getEntityPlayer() instanceof EntityPlayerMP && ItemUtils.isInputEqual((Object)"logWood", (ItemStack)entityItemPickupEvent.getItem().getItem(), (boolean)false, (boolean)false, (boolean)true)) {
            for (IRecipe recipe : CraftingManager.REGISTRY) {
                if (recipe.getRecipeOutput().getItem() != ModItems.TREE_TAP) continue;
                entityItemPickupEvent.getEntityPlayer().unlockRecipes(Collections.singletonList(recipe));
            }
        }
    }

    public static void unlockTRRecipes(EntityPlayerMP playerMP) {
        ArrayList<IRecipe> recipeList = new ArrayList<IRecipe>();
        for (IRecipe recipe : CraftingManager.REGISTRY) {
            if (!TRRecipeHandler.isRecipeValid(recipe)) continue;
            recipeList.add(recipe);
        }
        playerMP.unlockRecipes(recipeList);
    }

    private static boolean isRecipeValid(IRecipe recipe) {
        if (recipe.getRegistryName() == null) {
            return false;
        }
        if (!recipe.getRegistryName().getResourceDomain().equals("techreborn")) {
            return false;
        }
        if (!recipe.getRecipeOutput().getItem().getRegistryName().getResourceDomain().equals("techreborn")) {
            return false;
        }
        if (hiddenEntrys.contains(recipe.getRecipeOutput().getItem())) {
            return false;
        }
        for (Ingredient ingredient : recipe.getIngredients()) {
            if (!ingredient.apply(new ItemStack(ModItems.UU_MATTER))) continue;
            return false;
        }
        return true;
    }
}

