/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init;

import java.security.InvalidParameterException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.OreUtil;
import reborncore.common.util.RebornCraftingHelper;
import techreborn.Core;
import techreborn.api.recipe.machines.BlastFurnaceRecipe;
import techreborn.api.recipe.machines.CompressorRecipe;
import techreborn.api.recipe.machines.GrinderRecipe;
import techreborn.api.recipe.machines.VacuumFreezerRecipe;
import techreborn.blocks.BlockOre;
import techreborn.compat.CompatManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.IC2Duplicates;
import techreborn.init.ModItems;
import techreborn.init.recipes.AlloySmelterRecipes;
import techreborn.init.recipes.ChemicalReactorRecipes;
import techreborn.init.recipes.CraftingTableRecipes;
import techreborn.init.recipes.DistillationTowerRecipes;
import techreborn.init.recipes.ExtractorRecipes;
import techreborn.init.recipes.FluidGeneratorRecipes;
import techreborn.init.recipes.FluidReplicatorRecipes;
import techreborn.init.recipes.FusionReactorRecipes;
import techreborn.init.recipes.ImplosionCompressorRecipes;
import techreborn.init.recipes.IndustrialCentrifugeRecipes;
import techreborn.init.recipes.IndustrialElectrolyzerRecipes;
import techreborn.init.recipes.IndustrialGrinderRecipes;
import techreborn.init.recipes.IndustrialSawmillRecipes;
import techreborn.init.recipes.RollingMachineRecipes;
import techreborn.init.recipes.ScrapboxRecipes;
import techreborn.init.recipes.SmeltingRecipes;
import techreborn.items.ItemCells;
import techreborn.items.ingredients.ItemDusts;
import techreborn.items.ingredients.ItemDustsSmall;
import techreborn.items.ingredients.ItemIngots;
import techreborn.items.ingredients.ItemPlates;
import techreborn.utils.OreDictUtils;

@RebornRegistry(modID="techreborn")
public class ModRecipes {
    public static void init() {
        OreUtil.scanForOres();
        CompatManager.isQuantumStorageLoaded = Loader.isModLoaded((String)"quantumstorage");
        CraftingTableRecipes.init();
        SmeltingRecipes.init();
        ExtractorRecipes.init();
        RollingMachineRecipes.init();
        FluidGeneratorRecipes.init();
        IndustrialGrinderRecipes.init();
        IndustrialCentrifugeRecipes.init();
        IndustrialElectrolyzerRecipes.init();
        ImplosionCompressorRecipes.init();
        ScrapboxRecipes.init();
        ChemicalReactorRecipes.init();
        FusionReactorRecipes.init();
        DistillationTowerRecipes.init();
        AlloySmelterRecipes.init();
        FluidReplicatorRecipes.init();
        ModRecipes.addBlastFurnaceRecipes();
        ModRecipes.addVacuumFreezerRecipes();
        ModRecipes.addIc2Recipes();
        ModRecipes.addGrinderRecipes();
        ModRecipes.addCompressorRecipes();
    }

    public static void postInit() {
        if (ConfigTechReborn.disableRailcraftSteelNuggetRecipe) {
            Iterator iterator = FurnaceRecipes.instance().getSmeltingList().entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                if (!(entry.getValue() instanceof ItemStack) || !(entry.getKey() instanceof ItemStack)) continue;
                ItemStack input = (ItemStack)entry.getKey();
                ItemStack output = (ItemStack)entry.getValue();
                if (!ItemUtils.isInputEqual((Object)"nuggetSteel", (ItemStack)output, (boolean)true, (boolean)true, (boolean)false) || !ItemUtils.isInputEqual((Object)"nuggetIron", (ItemStack)input, (boolean)true, (boolean)true, (boolean)false)) continue;
                Core.logHelper.info((Object)"Removing a steelnugget smelting recipe");
                iterator.remove();
            }
        }
        IndustrialSawmillRecipes.init();
    }

    private static void addCompressorRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(ItemIngots.getIngotByName("advanced_alloy"), ItemPlates.getPlateByName("advanced_alloy"), 400, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(IC2Duplicates.CARBON_MESH.getStackBasedOnConfig(), ItemPlates.getPlateByName("carbon"), 400, 2));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"plankWood", (int)1), OreUtil.getStackFromName((String)"plateWood", (int)1), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"dustLazurite", (int)1), ItemPlates.getPlateByName("lazurite", 1), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"obsidian", (int)1), ItemPlates.getPlateByName("obsidian", 9), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"dustObsidian", (int)1), ItemPlates.getPlateByName("obsidian", 1), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"dustYellowGarnet", (int)1), ItemPlates.getPlateByName("YellowGarnet"), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"blockYellowGarnet", (int)1), ItemPlates.getPlateByName("YellowGarnet", 9), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"dustRedGarnet", (int)1), ItemPlates.getPlateByName("RedGarnet"), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"blockRedGarnet", (int)1), ItemPlates.getPlateByName("RedGarnet", 9), 300, 4));
        RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)"ingotRefinedIron", (int)1), ItemPlates.getPlateByName("RefinedIron"), 300, 4));
        for (String ore : OreUtil.oreNames) {
            ItemStack plate;
            if (ore.equals("iridium") || !OreUtil.hasPlate((String)ore)) continue;
            try {
                plate = ItemPlates.getPlateByName(ore, 1);
            }
            catch (InvalidParameterException e) {
                plate = OreUtil.getStackFromName((String)("plate" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1);
            }
            if (plate.isEmpty()) continue;
            if (OreUtil.hasIngot((String)ore)) {
                RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("ingot" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), plate, 300, 4));
            }
            if (OreUtil.hasGem((String)ore) && OreUtil.hasDust((String)ore)) {
                RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("dust" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), plate, 300, 4));
            }
            if (!OreUtil.hasBlock((String)ore)) continue;
            ItemStack morePlates = plate.copy();
            morePlates.setCount(9);
            RecipeHandler.addRecipe((IBaseRecipeType)new CompressorRecipe(OreUtil.getStackFromName((String)("block" + OreUtil.capitalizeFirstLetter((String)ore)), (int)1), morePlates, 300, 4));
        }
    }

    static void addGrinderRecipes() {
        ItemStack marbleStack;
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.BONE), new ItemStack(Items.DYE, 6, 15), 170, 19));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.COBBLESTONE), new ItemStack((Block)Blocks.SAND), 230, 23));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.GRAVEL), new ItemStack(Items.FLINT), 200, 20));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.COAL), ItemDusts.getDustByName("coal"), 230, 27));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.COAL, 1, 1), ItemDusts.getDustByName("charcoal"), 230, 27));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.CLAY_BALL), ItemDusts.getDustByName("clay"), 200, 18));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.GLOWSTONE), ItemDusts.getDustByName("glowstone", 4), 220, 21));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.NETHERRACK), ItemDusts.getDustByName("netherrack"), 300, 27));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.END_STONE), ItemDusts.getDustByName("endstone"), 300, 16));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.ENDER_EYE), ItemDusts.getDustByName("ender_eye", 2), 200, 22));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.ENDER_PEARL), ItemDusts.getDustByName("ender_pearl", 2), 200, 22));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.LAPIS_ORE), new ItemStack(Items.DYE, 10, 4), 170, 19));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Blocks.OBSIDIAN), ItemDusts.getDustByName("obsidian", 4), 170, 19));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(new ItemStack(Items.BLAZE_ROD), new ItemStack(Items.BLAZE_POWDER, 4), 170, 19));
        if (OreUtil.doesOreExistAndValid((String)"stoneMarble")) {
            marbleStack = ModRecipes.getOre("stoneMarble");
            marbleStack.setCount(1);
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(marbleStack, ItemDusts.getDustByName("marble"), 120, 10));
        }
        if (OreUtil.doesOreExistAndValid((String)"stoneBasalt")) {
            marbleStack = ModRecipes.getOre("stoneBasalt");
            marbleStack.setCount(1);
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(marbleStack, ItemDusts.getDustByName("basalt"), 120, 10));
        }
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreCoal", new ItemStack(Items.COAL, 2), 270, 31));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreDiamond", new ItemStack(Items.DIAMOND, 1), 270, 31));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreEmerald", new ItemStack(Items.EMERALD, 1), 270, 31));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreRedstone", new ItemStack(Items.REDSTONE, 8), 270, 31));
        RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe("oreQuartz", new ItemStack(Items.QUARTZ, 2), 270, 31));
        for (String oreDictionaryName : OreDictionary.getOreNames()) {
            if (!OreDictUtils.isDictPrefixed(oreDictionaryName, "ore", "gem", "ingot")) continue;
            ItemStack oreStack = OreDictUtils.getDictOreOrEmpty(oreDictionaryName, 1);
            String[] data = OreDictUtils.getDictData(oreDictionaryName);
            if (data[0].equals("ore") && (data[1].equals("tungsten") || data[1].equals("titanium") || data[1].equals("aluminium") || data[1].equals("iridium") || data[1].equals("saltpeter") || data[1].equals("coal") || data[1].equals("diamond") || data[1].equals("emerald") || data[1].equals("redstone") || data[1].equals("quartz")) || oreStack.isEmpty()) continue;
            boolean ore = data[0].equals("ore");
            Core.logHelper.debug((Object)("Ore: " + data[1]));
            ItemStack dust = OreDictUtils.getDictOreOrEmpty(OreDictUtils.joinDictName("dust", data[1]), ore ? 2 : 1);
            if (dust.isEmpty() || dust.getItem() == null) continue;
            dust = dust.copy();
            if (ore) {
                dust.setCount(2);
            }
            boolean useOreDict = true;
            if (data[1].equalsIgnoreCase("lapis")) {
                useOreDict = false;
            }
            RecipeHandler.addRecipe((IBaseRecipeType)new GrinderRecipe(oreStack, dust, ore ? 270 : 200, ore ? 31 : 22, useOreDict));
        }
    }

    static void addVacuumFreezerRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(new ItemStack(Blocks.ICE, 2), new ItemStack(Blocks.PACKED_ICE), 60, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemIngots.getIngotByName("hot_tungstensteel"), ItemIngots.getIngotByName("tungstensteel"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("heliumplasma"), ItemCells.getCellByName("helium"), 440, 64));
        RecipeHandler.addRecipe((IBaseRecipeType)new VacuumFreezerRecipe(ItemCells.getCellByName("water"), ItemCells.getCellByName("cell"), 60, 64));
    }

    static void addBlastFurnaceRecipes() {
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("titanium"), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("titanium", 4), null, ItemIngots.getIngotByName("titanium"), null, 3600, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("aluminum"), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("aluminum", 4), null, ItemIngots.getIngotByName("aluminum"), null, 2200, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("tungsten"), null, ItemIngots.getIngotByName("tungsten"), null, 1800, 120, 2500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("tungsten", 4), null, ItemIngots.getIngotByName("tungsten"), null, 1800, 120, 2500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("chrome"), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("chrome", 4), null, ItemIngots.getIngotByName("chrome"), null, 4420, 120, 1700));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("steel"), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDustsSmall.getSmallDustByName("steel", 4), null, ItemIngots.getIngotByName("steel"), null, 2800, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemDusts.getDustByName("galena", 2), null, ItemIngots.getIngotByName("silver"), ItemIngots.getIngotByName("lead"), 80, 120, 1500));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(new ItemStack(Items.IRON_INGOT), ItemDusts.getDustByName("coal", 2), ItemIngots.getIngotByName("steel"), ItemDusts.getDustByName("dark_ashes", 2), 500, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(ItemIngots.getIngotByName("tungsten"), ItemIngots.getIngotByName("steel"), ItemIngots.getIngotByName("hot_tungstensteel"), ItemDusts.getDustByName("dark_ashes", 4), 500, 128, 3000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(new ItemStack(Blocks.IRON_ORE), ItemDusts.getDustByName("calcite"), new ItemStack(Items.IRON_INGOT, 3), ItemDusts.getDustByName("dark_ashes"), 140, 120, 1000));
        RecipeHandler.addRecipe((IBaseRecipeType)new BlastFurnaceRecipe(BlockOre.getOreByName("Pyrite"), ItemDusts.getDustByName("calcite"), new ItemStack(Items.IRON_INGOT, 2), ItemDusts.getDustByName("dark_ashes"), 140, 120, 1000));
    }

    static void addIc2Recipes() {
        RebornCraftingHelper.addShapelessOreRecipe((ItemStack)new ItemStack(ModItems.MANUAL), (Object[])new Object[]{IC2Duplicates.REFINED_IRON.getStackBasedOnConfig(), Items.BOOK});
    }

    public static ItemStack getBucketWithFluid(Fluid fluid) {
        return FluidUtil.getFilledBucket((FluidStack)new FluidStack(fluid, 1000));
    }

    public static ItemStack getOre(String name) {
        if (OreDictionary.getOres((String)name).isEmpty()) {
            return new ItemStack(ModItems.MISSING_RECIPE_PLACEHOLDER);
        }
        return ((ItemStack)OreDictionary.getOres((String)name).get(0)).copy();
    }
}

