/*
 * Decompiled with CFR 0.152.
 */
package techreborn.init.recipes;

import java.security.InvalidParameterException;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;
import reborncore.api.recipe.IBaseRecipeType;
import reborncore.api.recipe.RecipeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.ItemUtils;
import techreborn.api.recipe.machines.IndustrialSawmillRecipe;
import techreborn.init.recipes.RecipeMethods;
import techreborn.items.ingredients.ItemDusts;

@RebornRegistry(modID="techreborn")
public class IndustrialSawmillRecipes
extends RecipeMethods {
    static FluidStack WATER = new FluidStack(FluidRegistry.WATER, 1000);
    @ConfigRegistry(config="recipes", category="sawmill", key="plankCount", comment="Number of planks the saw mill will ouput")
    public static int plankCount = 4;
    @ConfigRegistry(config="recipes", category="sawmill", key="disableRecipes", comment="Set to true to disable sawmill recipes from loading.")
    public static boolean disableRecipes = false;

    public static void init() {
        if (disableRecipes) {
            return;
        }
        InventoryCrafting inventoryCrafting = new InventoryCrafting(new Container(){

            public boolean canInteractWith(EntityPlayer playerIn) {
                return false;
            }
        }, 1, 1);
        inventoryCrafting.setInventorySlotContents(0, ItemStack.EMPTY);
        List logs = OreDictionary.getOres((String)"logWood").stream().filter(Objects::nonNull).map(ItemStack::copy).collect(Collectors.toList());
        for (ItemStack logStack : logs) {
            if (logStack.getItemDamage() == Short.MAX_VALUE && logStack.getHasSubtypes()) {
                for (int i = 0; i < 16; ++i) {
                    ItemStack newStack = logStack.copy();
                    newStack.setItemDamage(i);
                    inventoryCrafting.setInventorySlotContents(0, newStack);
                    ItemStack output = IndustrialSawmillRecipes.findMatchingRecipe(inventoryCrafting);
                    if (output.isEmpty() || !ItemUtils.isInputEqual((Object)"plankWood", (ItemStack)output, (boolean)false, (boolean)false, (boolean)false)) continue;
                    IndustrialSawmillRecipes.addRecipe(newStack.copy(), output.copy());
                }
                continue;
            }
            logStack.setItemDamage(0);
            inventoryCrafting.setInventorySlotContents(0, logStack.copy());
            ItemStack output = IndustrialSawmillRecipes.findMatchingRecipe(inventoryCrafting);
            if (output.isEmpty() || !ItemUtils.isInputEqual((Object)"plankWood", (ItemStack)output, (boolean)false, (boolean)false, (boolean)false)) continue;
            IndustrialSawmillRecipes.addRecipe(logStack.copy(), output.copy());
        }
    }

    @Nonnull
    public static ItemStack findMatchingRecipe(InventoryCrafting inv) {
        for (IRecipe recipe : CraftingManager.REGISTRY) {
            if (!recipe.canFit(1, 1) || !recipe.matches(inv, null)) continue;
            return recipe.getCraftingResult(inv);
        }
        return ItemStack.EMPTY;
    }

    public static void addRecipe(ItemStack log, ItemStack plank) {
        plank.setCount(plankCount);
        IndustrialSawmillRecipes.register(log, WATER, 100, 128, plank, ItemDusts.getDustByName("sawDust", 3), IndustrialSawmillRecipes.getStack(Items.PAPER, 1));
    }

    static void register(ItemStack input1, FluidStack fluid, int ticks, int euPerTick, ItemStack ... outputs) {
        if (outputs.length == 3) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], outputs[1], outputs[2], ticks, euPerTick, false));
        } else if (outputs.length == 2) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], outputs[1], null, ticks, euPerTick, false));
        } else if (outputs.length == 1) {
            RecipeHandler.addRecipe((IBaseRecipeType)new IndustrialSawmillRecipe(input1, fluid, outputs[0], null, null, ticks, euPerTick, false));
        } else {
            throw new InvalidParameterException("Invalid industrial sawmill outputs: " + outputs);
        }
    }
}

