/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import net.minecraft.block.Block;
import net.minecraft.block.BlockStaticLiquid;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStack;
import org.apache.commons.lang3.Validate;
import reborncore.common.util.StringUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModItems;
import techreborn.utils.TechRebornCreativeTab;

public class DynamicCell
extends Item {
    public static final int CAPACITY = 1000;

    public DynamicCell() {
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setUnlocalizedName("techreborn.cell");
        this.setMaxStackSize(64);
        TRRecipeHandler.hideEntry(this);
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        NBTTagCompound tag;
        if (stack.hasTagCompound() && ((tag = stack.getTagCompound()).getSize() != 1 || tag.hasKey("Fluid"))) {
            NBTTagCompound clearTag = new NBTTagCompound();
            clearTag.setTag("Fluid", (NBTBase)tag.getCompoundTag("Fluid"));
            stack.setTagCompound(clearTag);
        }
    }

    public ActionResult<ItemStack> onItemRightClick(World worldIn, EntityPlayer playerIn, EnumHand hand) {
        RayTraceResult result;
        ItemStack stack = playerIn.getHeldItem(hand);
        if (!worldIn.isRemote && (result = this.rayTrace(worldIn, playerIn, true)) != null && result.typeOfHit == RayTraceResult.Type.BLOCK) {
            BlockPos pos = result.getBlockPos();
            IBlockState state = worldIn.getBlockState(pos);
            Block block = state.getBlock();
            if (block instanceof IFluidBlock) {
                FluidStack fluid;
                IFluidBlock fluidBlock = (IFluidBlock)block;
                if (fluidBlock.canDrain(worldIn, pos) && (fluid = fluidBlock.drain(worldIn, pos, false)) != null && fluid.amount == 1000 && this.tryAddCellToInventory(playerIn, stack, fluid.getFluid())) {
                    fluidBlock.drain(worldIn, pos, true);
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            } else if (block instanceof BlockStaticLiquid) {
                Fluid fluid;
                Fluid fluid2 = fluid = state.getMaterial() == Material.LAVA ? FluidRegistry.LAVA : FluidRegistry.WATER;
                if (this.tryAddCellToInventory(playerIn, stack, fluid)) {
                    if (fluid != FluidRegistry.WATER) {
                        worldIn.setBlockToAir(pos);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                }
            } else {
                ItemStack usedCell = stack.copy();
                usedCell.setCount(1);
                IFluidHandlerItem fluidHandler = FluidUtil.getFluidHandler((ItemStack)usedCell);
                if (fluidHandler != null) {
                    FluidStack fluid = fluidHandler.drain(1000, false);
                    if (fluid != null) {
                        if (FluidUtil.tryPlaceFluid((EntityPlayer)playerIn, (World)worldIn, (BlockPos)pos.offset(result.sideHit), (IFluidHandler)fluidHandler, (FluidStack)fluid)) {
                            stack.shrink(1);
                            playerIn.inventory.addItemStackToInventory(DynamicCell.getEmptyCell(1));
                            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
                        }
                        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                    }
                    return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
            }
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)stack);
    }

    public boolean tryAddCellToInventory(EntityPlayer player, ItemStack stack, Fluid fluid) {
        if (player.inventory.addItemStackToInventory(DynamicCell.getCellWithFluid(fluid))) {
            stack.shrink(1);
            return true;
        }
        return false;
    }

    public void getSubItems(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.isInCreativeTab(tab)) {
            return;
        }
        subItems.add((Object)DynamicCell.getEmptyCell(1));
        for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
            subItems.add((Object)DynamicCell.getCellWithFluid(fluid));
        }
    }

    public String getItemStackDisplayName(ItemStack stack) {
        FluidStack fluidStack = DynamicCell.getFluidHandler(stack).getFluid();
        if (fluidStack == null) {
            return super.getItemStackDisplayName(stack);
        }
        return StringUtils.t((String)"item.techreborn.cell.fluid.name").replaceAll("\\$fluid\\$", fluidStack.getLocalizedName());
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return DynamicCell.getFluidHandler(stack);
    }

    public static FluidHandler getFluidHandler(ItemStack stack) {
        return new FluidHandler(stack, 1000);
    }

    public static ItemStack getCellWithFluid(Fluid fluid, int stackSize) {
        Validate.notNull((Object)fluid);
        ItemStack stack = new ItemStack((Item)ModItems.CELL);
        DynamicCell.getFluidHandler(stack).fill(new FluidStack(fluid, 1000), true);
        stack.setCount(stackSize);
        return stack;
    }

    public static ItemStack getEmptyCell(int amount) {
        return new ItemStack((Item)ModItems.CELL, amount);
    }

    public static ItemStack getCellWithFluid(Fluid fluid) {
        return DynamicCell.getCellWithFluid(fluid, 1);
    }

    public static class FluidHandler
    extends FluidHandlerItemStack {
        public FluidHandler(ItemStack container, int capacity) {
            super(container, capacity);
            FluidStack stack;
            if (container.hasTagCompound() && container.getTagCompound().hasKey("FluidName") && (stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.getTagCompound())) != null) {
                container.setTagCompound(new NBTTagCompound());
                this.fill(stack, true);
            }
        }

        public int fill(FluidStack resource, boolean doFill) {
            if (resource == null) {
                return 0;
            }
            if (resource.amount > this.capacity) {
                resource.amount = this.capacity;
            }
            if (resource.amount != this.capacity) {
                return 0;
            }
            return super.fill(resource, doFill);
        }

        public FluidStack drain(int maxDrain, boolean doDrain) {
            if (maxDrain > this.capacity) {
                maxDrain = this.capacity;
            }
            if (maxDrain != this.capacity) {
                return null;
            }
            return super.drain(maxDrain, doDrain);
        }

        public ItemStack getContainer() {
            ItemStack cell = this.container.hasTagCompound() && this.container.getTagCompound().hasKey("Fluid") ? super.getContainer() : new ItemStack((Item)ModItems.CELL, 1);
            return cell;
        }

        protected void setContainerToEmpty() {
            this.container = new ItemStack((Item)ModItems.CELL, 1);
        }
    }
}

