/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.Validate;
import reborncore.common.util.StringUtils;
import techreborn.items.DynamicCell;

public class ItemCells {
    public static ItemStack getCellByName(String name, int count) {
        if (name.equalsIgnoreCase("empty") || name.equalsIgnoreCase("cell")) {
            return DynamicCell.getEmptyCell(count).copy();
        }
        Fluid fluid = FluidRegistry.getFluid((String)("fluid" + name.toLowerCase()));
        if (fluid == null && (fluid = FluidRegistry.getFluid((String)name.toLowerCase())) == null) {
            fluid = FluidRegistry.getFluid((String)("fluid" + StringUtils.toFirstCapital((String)name.toLowerCase())));
        }
        Validate.notNull((Object)fluid, (String)("The fluid " + name + " could not be found"), (Object[])new Object[0]);
        return DynamicCell.getCellWithFluid(fluid, count);
    }

    public static ItemStack getCellByName(String name) {
        return ItemCells.getCellByName(name, 1);
    }

    public static boolean isCellEqual(ItemStack stack1, ItemStack stack2) {
        if (stack1 == null || stack2 == null) {
            return false;
        }
        if (stack1.isEmpty() || stack2.isEmpty()) {
            return false;
        }
        if (stack1.getTagCompound() == null || stack2.getTagCompound() == null) {
            return false;
        }
        return stack1.getTagCompound().equals((Object)stack2.getTagCompound());
    }
}

