/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.client.hud.StackInfoElement;
import reborncore.common.util.ChatUtils;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;
import techreborn.lib.MessageIDs;

public class ItemFrequencyTransmitter
extends ItemTR {
    public ItemFrequencyTransmitter() {
        this.setUnlocalizedName("techreborn.frequencyTransmitter");
        this.setMaxStackSize(1);
        this.addPropertyOverride(new ResourceLocation("techreborn:coords"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (!stack.isEmpty() && stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public EnumActionResult onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.getHeldItem(hand);
        stack.setTagCompound(new NBTTagCompound());
        stack.getTagCompound().setInteger("x", pos.getX());
        stack.getTagCompound().setInteger("y", pos.getY());
        stack.getTagCompound().setInteger("z", pos.getZ());
        stack.getTagCompound().setInteger("dim", world.provider.getDimension());
        if (!world.isRemote) {
            ChatUtils.sendNoSpamMessages((int)MessageIDs.freqTransmitterID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.setTo", (Object[])new Object[0]) + " X: " + TextFormatting.GOLD + pos.getX() + TextFormatting.GRAY + " Y: " + TextFormatting.GOLD + pos.getY() + TextFormatting.GRAY + " Z: " + TextFormatting.GOLD + pos.getZ() + TextFormatting.GRAY + " " + I18n.format((String)"techreborn.message.in", (Object[])new Object[0]) + " " + TextFormatting.GOLD + DimensionManager.getProviderType((int)world.provider.getDimension()).getName() + " (" + world.provider.getDimension() + ")"));
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking()) {
            stack.setTagCompound(null);
            if (!world.isRemote) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.freqTransmitterID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.coordsHaveBeen", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.format((String)"techreborn.message.cleared", (Object[])new Object[0])));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
            int x = stack.getTagCompound().getInteger("x");
            int y = stack.getTagCompound().getInteger("y");
            int z = stack.getTagCompound().getInteger("z");
            int dim = stack.getTagCompound().getInteger("dim");
            tooltip.add(TextFormatting.GRAY + "X: " + TextFormatting.GOLD + x);
            tooltip.add(TextFormatting.GRAY + "Y: " + TextFormatting.GOLD + y);
            tooltip.add(TextFormatting.GRAY + "Z: " + TextFormatting.GOLD + z);
            tooltip.add(TextFormatting.DARK_GRAY + DimensionManager.getProviderType((int)dim).getName());
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.format((String)"techreborn.message.noCoordsSet", (Object[])new Object[0]));
        }
    }

    public static class StackInfoFreqTransmitter
    extends StackInfoElement {
        public StackInfoFreqTransmitter() {
            super(ModItems.FREQUENCY_TRANSMITTER);
        }

        public String getText(ItemStack stack) {
            String text = "";
            TextFormatting gold = TextFormatting.GOLD;
            TextFormatting grey = TextFormatting.GRAY;
            if (stack.getItem() instanceof ItemFrequencyTransmitter) {
                if (stack.hasTagCompound() && stack.getTagCompound() != null && stack.getTagCompound().hasKey("x") && stack.getTagCompound().hasKey("y") && stack.getTagCompound().hasKey("z") && stack.getTagCompound().hasKey("dim")) {
                    int coordX = stack.getTagCompound().getInteger("x");
                    int coordY = stack.getTagCompound().getInteger("y");
                    int coordZ = stack.getTagCompound().getInteger("z");
                    int coordDim = stack.getTagCompound().getInteger("dim");
                    text = grey + "X: " + gold + coordX + grey + " Y: " + gold + coordY + grey + " Z: " + gold + coordZ + grey + " Dim: " + gold + DimensionManager.getProviderType((int)coordDim).getName() + " (" + coordDim + ")";
                } else {
                    text = grey + I18n.format((String)"techreborn.message.noCoordsSet", (Object[])new Object[0]);
                }
            }
            return text;
        }
    }
}

