/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items;

import java.security.InvalidParameterException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.inventory.Container;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.tile.IUpgrade;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.IUpgradeHandler;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;

@RebornRegistry(modID="techreborn")
public class ItemUpgrades
extends ItemTR
implements IUpgrade {
    @ConfigRegistry(config="items", category="upgrades", key="overclocker_speed", comment="Overclocker upgrade speed multipiler")
    public static double overclockerSpeed = 0.25;
    @ConfigRegistry(config="items", category="upgrades", key="overclocker_power", comment="Overclocker upgrade power multipiler")
    public static double overclockerPower = 0.75;
    @ConfigRegistry(config="items", category="upgrades", key="energy_storage", comment="Energy storage upgrade extra power")
    public static double energyStoragePower = 40000.0;
    public static final String[] types = new String[]{"overclock", "transformer", "energy_storage"};

    public ItemUpgrades() {
        this.setUnlocalizedName("techreborn.upgrade");
        this.setHasSubtypes(true);
        this.setMaxStackSize(16);
    }

    public static ItemStack getUpgradeByName(String name, int count) {
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.UPGRADES, count, i);
        }
        throw new InvalidParameterException("The upgrade " + name + " could not be found.");
    }

    public static ItemStack getUpgradeByName(String name) {
        return ItemUpgrades.getUpgradeByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!this.isInCreativeTab(creativeTabs)) {
            return;
        }
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }

    public void process(@Nonnull TileLegacyMachineBase machineBase, @Nullable IUpgradeHandler handler, @Nonnull ItemStack stack) {
        if (stack.getItemDamage() == 0) {
            handler.addSpeedMulti(overclockerSpeed);
            handler.addPowerMulti(overclockerPower);
            if (machineBase instanceof TilePowerAcceptor) {
                TilePowerAcceptor powerAcceptor = (TilePowerAcceptor)machineBase;
                powerAcceptor.extraPowerInput += powerAcceptor.getMaxInput();
                powerAcceptor.extraPowerStoage += powerAcceptor.getBaseMaxPower();
            }
        }
        if (machineBase instanceof TilePowerAcceptor) {
            TilePowerAcceptor acceptor;
            if (stack.getItemDamage() == 2) {
                acceptor = (TilePowerAcceptor)machineBase;
                acceptor.extraPowerStoage += energyStoragePower;
            }
            if (stack.getItemDamage() == 1) {
                acceptor = (TilePowerAcceptor)machineBase;
                ++acceptor.extraTeir;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void handleRightClick(TileEntity tile, ItemStack stack, Container container, int slotID) {
    }
}

