/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import javax.annotation.Nullable;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.armor.ItemTRArmour;
import techreborn.utils.TechRebornCreativeTab;

@RebornRegistry(modID="techreborn")
public class ItemCloakingDevice
extends ItemTRArmour
implements IEnergyItemInfo {
    @ConfigRegistry(config="items", category="cloacking_device", key="ClockingDeviceEnergyUsage", comment="Cloacking device energy usesage (Value in FE)")
    public static int usage = 10;
    public static int MaxCharge = ConfigTechReborn.CloakingDeviceCharge;
    public static int Limit = 100;
    public static boolean isActive;

    public ItemCloakingDevice() {
        super(Reference.CLOAKING_ARMOR, EntityEquipmentSlot.CHEST);
        this.setUnlocalizedName("techreborn.cloakingdevice");
        this.setMaxStackSize(1);
        this.setCreativeTab(TechRebornCreativeTab.instance);
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return "techreborn:textures/models/cloaking.png";
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack stack) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy != null && capEnergy.getEnergyStored() >= usage) {
            capEnergy.extractEnergy(usage, false);
            player.setInvisible(true);
        } else if (!player.isPotionActive(MobEffects.INVISIBILITY)) {
            player.setInvisible(false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.isInCreativeTab(par2CreativeTabs)) {
            return;
        }
        ItemStack uncharged = new ItemStack(ModItems.CLOAKING_DEVICE);
        ItemStack charged = new ItemStack(ModItems.CLOAKING_DEVICE);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)uncharged);
        itemList.add((Object)charged);
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public double getMaxPower(ItemStack stack) {
        return MaxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack itemStack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return Limit;
    }
}

