/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.armor;

import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import reborncore.common.util.ItemUtils;
import techreborn.events.TRRecipeHandler;
import techreborn.utils.TechRebornCreativeTab;

public class ItemTRArmour
extends ItemArmor {
    String repairOreDict = "";

    public ItemTRArmour(ItemArmor.ArmorMaterial material, EntityEquipmentSlot slot) {
        this(material, slot, "");
    }

    public ItemTRArmour(ItemArmor.ArmorMaterial material, EntityEquipmentSlot slot, String repairOreDict) {
        super(material, material.getDamageReductionAmount(slot), slot);
        this.repairOreDict = repairOreDict;
        if (slot == EntityEquipmentSlot.HEAD) {
            this.setUnlocalizedName(material.name().toLowerCase() + "Helmet");
        }
        if (slot == EntityEquipmentSlot.CHEST) {
            this.setUnlocalizedName(material.name().toLowerCase() + "Chestplate");
        }
        if (slot == EntityEquipmentSlot.LEGS) {
            this.setUnlocalizedName(material.name().toLowerCase() + "Leggings");
        }
        if (slot == EntityEquipmentSlot.FEET) {
            this.setUnlocalizedName(material.name().toLowerCase() + "Boots");
        }
        this.setCreativeTab(TechRebornCreativeTab.instance);
        TRRecipeHandler.hideEntry(this);
    }

    public boolean getIsRepairable(ItemStack toRepair, ItemStack repair) {
        if (toRepair.getItem() == this && !this.repairOreDict.isEmpty()) {
            return ItemUtils.isInputEqual((Object)this.repairOreDict, (ItemStack)repair, (boolean)false, (boolean)false, (boolean)true);
        }
        return super.getIsRepairable(toRepair, repair);
    }
}

