/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.battery;

import javax.annotation.Nullable;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.items.ItemTR;

public class ItemBattery
extends ItemTR
implements IEnergyItemInfo {
    String name;
    int maxEnergy = 0;
    int maxTransfer = 0;

    public ItemBattery(String name, int maxEnergy, int maxTransfer) {
        this.setMaxStackSize(1);
        this.setMaxDamage(1);
        this.setUnlocalizedName("techreborn." + name);
        this.name = name;
        this.maxEnergy = maxEnergy;
        this.maxTransfer = maxTransfer;
        this.addPropertyOverride(new ResourceLocation("techreborn:empty"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (!stack.isEmpty() && new ForgePowerItemManager(stack).getEnergyStored() == 0) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public double getMaxPower(ItemStack stack) {
        return this.maxEnergy;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return true;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.maxTransfer;
    }
}

