/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.ingredients;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;

public class ItemGems
extends ItemTR {
    public static final String[] types = new String[]{"ruby", "sapphire", "peridot", "red_garnet", "yellow_garnet"};

    public ItemGems() {
        this.setUnlocalizedName("techreborn.gem");
        this.setHasSubtypes(true);
        TRRecipeHandler.hideEntry(this);
    }

    public static ItemStack getGemByName(String name, int count) {
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            return new ItemStack(ModItems.GEMS, count, i);
        }
        throw new InvalidParameterException("The gem " + name + " could not be found.");
    }

    public static ItemStack getGemByName(String name) {
        return ItemGems.getGemByName(name, 1);
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!this.isInCreativeTab(creativeTabs)) {
            return;
        }
        for (int meta = 0; meta < types.length; ++meta) {
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }
}

