/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.ingredients;

import com.google.common.base.CaseFormat;
import java.security.InvalidParameterException;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import reborncore.common.util.OreUtil;
import techreborn.events.TRRecipeHandler;
import techreborn.init.ModItems;
import techreborn.items.ItemTR;
import techreborn.utils.TechRebornCreativeTab;

public class ItemPlates
extends ItemTR {
    public static String[] types = new String[]{"iron", "gold", "carbon", "wood", "redstone", "diamond", "emerald", "PLACEHOLDER_ITEM", "coal", "obsidian", "lazurite"};

    public ItemPlates() {
        this.setUnlocalizedName("techreborn.plate");
        this.setHasSubtypes(true);
        this.setCreativeTab(TechRebornCreativeTab.instance);
        TRRecipeHandler.hideEntry(this);
    }

    public static ItemStack getPlateByName(String name, int count) {
        name = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, name);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equalsIgnoreCase(name)) continue;
            if (types[i].equals("PLACEHOLDER_ITEM")) {
                throw new InvalidParameterException("The plate " + name + " could not be found.");
            }
            return new ItemStack(ModItems.PLATES, count, i);
        }
        throw new InvalidParameterException("The plate " + name + " could not be found.");
    }

    public static ItemStack getPlateByName(String name) {
        return ItemPlates.getPlateByName(name, 1);
    }

    public static void registerType(String plateType) {
        for (String type : types) {
            if (!type.equals(plateType)) continue;
            return;
        }
        int plateIndex = types.length;
        String[] newTypes = new String[plateIndex + 1];
        System.arraycopy(types, 0, newTypes, 0, types.length);
        types = newTypes;
        newTypes[plateIndex] = plateType;
        String oreName = "plate" + CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, plateType);
        OreUtil.registerOre((String)oreName, (ItemStack)new ItemStack(ModItems.PLATES, 1, plateIndex));
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        int meta = itemStack.getItemDamage();
        if (meta < 0 || meta >= types.length) {
            meta = 0;
        }
        return super.getUnlocalizedName() + "." + types[meta];
    }

    public void getSubItems(CreativeTabs creativeTabs, NonNullList<ItemStack> list) {
        if (!this.isInCreativeTab(creativeTabs)) {
            return;
        }
        for (int meta = 0; meta < types.length; ++meta) {
            if (types[meta].equals("PLACEHOLDER_ITEM")) continue;
            list.add((Object)new ItemStack((Item)this, 1, meta));
        }
    }
}

