/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemChainsaw;

public class ItemAdvancedChainsaw
extends ItemChainsaw {
    public ItemAdvancedChainsaw() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedChainsaw", ConfigTechReborn.AdvancedChainsawCharge, 1.0f);
        this.cost = 250;
        this.transferLimit = 1000.0;
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.isInCreativeTab(par2CreativeTabs)) {
            return;
        }
        ItemStack stack = new ItemStack(ModItems.ADVANCED_CHAINSAW);
        ItemStack charged = stack.copy();
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)stack);
        itemList.add((Object)charged);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        for (int i = 1; i < 10; ++i) {
            BlockPos nextPos = pos.up(i);
            IBlockState nextState = worldIn.getBlockState(nextPos);
            if (!nextState.getBlock().isWood((IBlockAccess)worldIn, nextPos)) continue;
            this.breakBlock(nextPos, stack, worldIn, entityLiving, pos);
        }
        return super.onBlockDestroyed(stack, worldIn, blockIn, pos, entityLiving);
    }

    public boolean canHarvestBlock(IBlockState blockIn) {
        return Items.DIAMOND_AXE.canHarvestBlock(blockIn);
    }

    public void breakBlock(BlockPos pos, ItemStack stack, World world, EntityLivingBase entityLiving, BlockPos oldPos) {
        if (oldPos == pos) {
            return;
        }
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() < this.cost) {
            return;
        }
        IBlockState blockState = world.getBlockState(pos);
        if (blockState.getBlockHardness(world, pos) == -1.0f) {
            return;
        }
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        capEnergy.extractEnergy(this.cost, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        blockState.getBlock().harvestBlock(world, (EntityPlayer)entityLiving, pos, blockState, world.getTileEntity(pos), stack);
        world.setBlockToAir(pos);
        world.removeTileEntity(pos);
    }
}

