/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.items.tools.ItemDrill;

public class ItemAdvancedDrill
extends ItemDrill {
    public ItemAdvancedDrill() {
        super(Item.ToolMaterial.DIAMOND, "techreborn.advancedDrill", ConfigTechReborn.AdvancedDrillCharge, 2.0f, 10.0f);
        this.cost = 250;
        this.transferLimit = 1000.0;
    }

    public Set<BlockPos> getTargetBlocks(World worldIn, BlockPos pos, @Nullable EntityPlayer playerIn) {
        HashSet<BlockPos> targetBlocks;
        block9: {
            EnumFacing enumfacing;
            block10: {
                block8: {
                    targetBlocks = new HashSet<BlockPos>();
                    if (!(playerIn instanceof EntityPlayer)) {
                        return new HashSet<BlockPos>();
                    }
                    RayTraceResult raytrace = this.rayTrace(worldIn, playerIn, false);
                    if (raytrace == null || raytrace.sideHit == null) {
                        return Collections.emptySet();
                    }
                    enumfacing = raytrace.sideHit;
                    if (enumfacing != EnumFacing.SOUTH && enumfacing != EnumFacing.NORTH) break block8;
                    for (int i = -1; i < 2; ++i) {
                        for (int j = -1; j < 2; ++j) {
                            BlockPos newPos = pos.add(i, j, 0);
                            if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                            targetBlocks.add(newPos);
                        }
                    }
                    break block9;
                }
                if (enumfacing != EnumFacing.EAST && enumfacing != EnumFacing.WEST) break block10;
                for (int i = -1; i < 2; ++i) {
                    for (int j = -1; j < 2; ++j) {
                        BlockPos newPos = pos.add(0, j, i);
                        if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                        targetBlocks.add(newPos);
                    }
                }
                break block9;
            }
            if (enumfacing != EnumFacing.DOWN && enumfacing != EnumFacing.UP) break block9;
            for (int i = -1; i < 2; ++i) {
                for (int j = -1; j < 2; ++j) {
                    BlockPos newPos = pos.add(j, 0, i);
                    if (!this.shouldBreak(playerIn, worldIn, pos, newPos)) continue;
                    targetBlocks.add(newPos);
                }
            }
        }
        return targetBlocks;
    }

    public void breakBlock(BlockPos pos, World world, EntityPlayer playerIn, ItemStack drill) {
        IBlockState blockState = world.getBlockState(pos);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(drill);
        capEnergy.extractEnergy(this.cost, false);
        ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)playerIn);
        blockState.getBlock().harvestBlock(world, playerIn, pos, blockState, world.getTileEntity(pos), drill);
        world.setBlockToAir(pos);
        world.removeTileEntity(pos);
    }

    private boolean shouldBreak(EntityPlayer playerIn, World worldIn, BlockPos originalPos, BlockPos pos) {
        if (originalPos.equals((Object)pos)) {
            return false;
        }
        IBlockState blockState = worldIn.getBlockState(pos);
        if (blockState.getMaterial() == Material.AIR) {
            return false;
        }
        if (blockState.getMaterial().isLiquid()) {
            return false;
        }
        float blockHardness = blockState.getPlayerRelativeBlockHardness(playerIn, worldIn, pos);
        if (blockHardness == -1.0f) {
            return false;
        }
        float originalHardness = worldIn.getBlockState(originalPos).getPlayerRelativeBlockHardness(playerIn, worldIn, originalPos);
        return !(originalHardness / blockHardness > 10.0f);
    }

    @Override
    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        EntityPlayer playerIn = null;
        if (entityLiving instanceof EntityPlayer) {
            playerIn = (EntityPlayer)entityLiving;
        }
        for (BlockPos additionalPos : this.getTargetBlocks(worldIn, pos, playerIn)) {
            this.breakBlock(additionalPos, worldIn, playerIn, stack);
        }
        return super.onBlockDestroyed(stack, worldIn, blockIn, pos, entityLiving);
    }

    public boolean canHarvestBlock(IBlockState blockIn) {
        return (Items.DIAMOND_PICKAXE.canHarvestBlock(blockIn) || Items.DIAMOND_SHOVEL.canHarvestBlock(blockIn)) && !Items.DIAMOND_AXE.canHarvestBlock(blockIn);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.isInCreativeTab(par2CreativeTabs)) {
            return;
        }
        ItemStack stack = new ItemStack(ModItems.ADVANCED_DRILL);
        ItemStack charged = stack.copy();
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)stack);
        itemList.add((Object)charged);
    }
}

