/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;
import reborncore.api.power.IEnergyInterfaceTile;
import reborncore.common.powerSystem.PowerSystem;
import techreborn.items.ItemTR;

public class ItemDebugTool
extends ItemTR {
    public ItemDebugTool() {
        this.setUnlocalizedName("techreborn.debug");
    }

    public EnumActionResult onItemUse(EntityPlayer playerIn, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntity tile = worldIn.getTileEntity(pos);
        if (tile instanceof IEnergyInterfaceTile) {
            if (!tile.getWorld().isRemote) {
                playerIn.sendMessage((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Power" + TextFormatting.BLUE + PowerSystem.getLocaliszedPower((double)((IEnergyInterfaceTile)tile).getEnergy())));
            }
            return EnumActionResult.SUCCESS;
        }
        if (tile != null && tile.hasCapability(CapabilityEnergy.ENERGY, facing)) {
            if (!tile.getWorld().isRemote) {
                playerIn.sendMessage((ITextComponent)new TextComponentString(TextFormatting.GREEN + "Power " + TextFormatting.RED + ((IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, facing)).getEnergyStored() + "FU"));
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }
}

