/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.utils.TechRebornCreativeTab;

public class ItemDrill
extends ItemPickaxe
implements IEnergyItemInfo {
    public int maxCharge = 1;
    public int cost = 250;
    public float unpoweredSpeed = 2.0f;
    public double transferLimit = 100.0;

    public ItemDrill(Item.ToolMaterial material, String unlocalizedName, int energyCapacity, float unpoweredSpeed, float efficiencyOnProperMaterial) {
        super(material);
        this.efficiency = efficiencyOnProperMaterial;
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.setUnlocalizedName(unlocalizedName);
        this.maxCharge = energyCapacity;
        this.unpoweredSpeed = unpoweredSpeed;
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            return this.unpoweredSpeed;
        }
        if (Items.WOODEN_PICKAXE.getDestroySpeed(stack, state) > 1.0f || Items.WOODEN_SHOVEL.getDestroySpeed(stack, state) > 1.0f) {
            return this.efficiency;
        }
        return super.getDestroySpeed(stack, state);
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack) + 1) == 0) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        }
        return true;
    }

    public boolean hitEntity(ItemStack itemstack, EntityLivingBase entityliving, EntityLivingBase entityliving1) {
        return true;
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.isItemEqual(oldStack);
    }

    public double getMaxPower(ItemStack stack) {
        return this.maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return this.transferLimit;
    }
}

