/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ChatUtils;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.lib.MessageIDs;
import techreborn.utils.TechRebornCreativeTab;

public class ItemNanosaber
extends ItemSword
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.nanoSaberCharge;
    public int cost = 250;

    public ItemNanosaber() {
        super(Item.ToolMaterial.DIAMOND);
        this.setNoRepair();
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.setUnlocalizedName("techreborn.nanosaber");
        this.addPropertyOverride(new ResourceLocation("techreborn:active"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float apply(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                if (ItemUtils.isActive((ItemStack)stack)) {
                    ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
                    if ((double)(capEnergy.getMaxEnergyStored() - capEnergy.getEnergyStored()) >= 0.9 * (double)capEnergy.getMaxEnergyStored()) {
                        return 0.5f;
                    }
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    public boolean hitEntity(ItemStack stack, EntityLivingBase entityHit, EntityLivingBase entityHitter) {
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
        if (capEnergy.getEnergyStored() >= this.cost) {
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityHitter);
            return true;
        }
        return false;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        int modifier = 0;
        if (ItemUtils.isActive((ItemStack)stack)) {
            modifier = 9;
        }
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.ATTACK_DAMAGE.getName(), (Object)new AttributeModifier(ATTACK_DAMAGE_MODIFIER, "Weapon modifier", (double)modifier, 0));
            multimap.put((Object)SharedMonsterAttributes.ATTACK_SPEED.getName(), (Object)new AttributeModifier(ATTACK_SPEED_MODIFIER, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }

    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.getHeldItem(hand);
        if (player.isSneaking()) {
            if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.nanosaberEnergyErrorTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.format((String)"techreborn.message.nanosaberActivate", (Object[])new Object[0])));
            } else if (!ItemUtils.isActive((ItemStack)stack)) {
                if (stack.getTagCompound() == null) {
                    stack.setTagCompound(new NBTTagCompound());
                }
                stack.getTagCompound().setBoolean("isActive", true);
                if (world.isRemote) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.format((String)"techreborn.message.nanosaberActive", (Object[])new Object[0])));
                }
            } else {
                stack.getTagCompound().setBoolean("isActive", false);
                if (world.isRemote) {
                    ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.setTo", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.format((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0])));
                }
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.PASS, (Object)stack);
    }

    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (ItemUtils.isActive((ItemStack)stack) && new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            if (worldIn.isRemote) {
                ChatUtils.sendNoSpamMessages((int)MessageIDs.nanosaberID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.nanosaberEnergyError", (Object[])new Object[0]) + " " + TextFormatting.GOLD + I18n.format((String)"techreborn.message.nanosaberDeactivating", (Object[])new Object[0])));
            }
            stack.getTagCompound().setBoolean("isActive", false);
        }
    }

    public boolean isRepairable() {
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.isInCreativeTab(par2CreativeTabs)) {
            return;
        }
        ItemStack inactiveUncharged = new ItemStack(ModItems.NANOSABER);
        inactiveUncharged.setTagCompound(new NBTTagCompound());
        inactiveUncharged.getTagCompound().setBoolean("isActive", false);
        ItemStack inactiveCharged = new ItemStack(ModItems.NANOSABER);
        inactiveCharged.setTagCompound(new NBTTagCompound());
        inactiveCharged.getTagCompound().setBoolean("isActive", false);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(inactiveCharged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        ItemStack activeCharged = new ItemStack(ModItems.NANOSABER);
        activeCharged.setTagCompound(new NBTTagCompound());
        activeCharged.getTagCompound().setBoolean("isActive", true);
        ForgePowerItemManager capEnergy2 = new ForgePowerItemManager(activeCharged);
        capEnergy2.setEnergyStored(capEnergy2.getMaxEnergyStored());
        itemList.add((Object)inactiveUncharged);
        itemList.add((Object)inactiveCharged);
        itemList.add((Object)activeCharged);
    }

    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemUtils.isActive((ItemStack)stack)) {
            tooltip.add(TextFormatting.GRAY + I18n.format((String)"techreborn.message.nanosaberInactive", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.GRAY + I18n.format((String)"techreborn.message.nanosaberActive", (Object[])new Object[0]));
        }
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 1000.0;
    }
}

