/*
 * Decompiled with CFR 0.152.
 */
package techreborn.items.tools;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import reborncore.api.power.IEnergyItemInfo;
import reborncore.common.powerSystem.ExternalPowerSystems;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.PoweredItemContainerProvider;
import reborncore.common.powerSystem.forge.ForgePowerItemManager;
import reborncore.common.util.ItemUtils;
import techreborn.config.ConfigTechReborn;
import techreborn.init.ModItems;
import techreborn.utils.TechRebornCreativeTab;

public class ItemRockCutter
extends ItemPickaxe
implements IEnergyItemInfo {
    public static final int maxCharge = ConfigTechReborn.RockCutterCharge;
    public int cost = 500;

    public ItemRockCutter() {
        super(Item.ToolMaterial.DIAMOND);
        this.setUnlocalizedName("techreborn.rockcutter");
        this.setCreativeTab(TechRebornCreativeTab.instance);
        this.setMaxStackSize(1);
        this.efficiency = 16.0f;
    }

    public boolean canHarvestBlock(IBlockState state) {
        return Items.DIAMOND_PICKAXE.canHarvestBlock(state);
    }

    public float getDestroySpeed(ItemStack stack, IBlockState state) {
        if (new ForgePowerItemManager(stack).getEnergyStored() < this.cost) {
            return 2.0f;
        }
        return Items.DIAMOND_PICKAXE.getDestroySpeed(stack, state);
    }

    public boolean onBlockDestroyed(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        Random rand = new Random();
        if (rand.nextInt(EnchantmentHelper.getEnchantmentLevel((Enchantment)Enchantments.UNBREAKING, (ItemStack)stack) + 1) == 0) {
            ForgePowerItemManager capEnergy = new ForgePowerItemManager(stack);
            capEnergy.extractEnergy(this.cost, false);
            ExternalPowerSystems.requestEnergyFromArmor((ForgePowerItemManager)capEnergy, (EntityLivingBase)entityLiving);
        }
        return true;
    }

    public int getHarvestLevel(ItemStack stack, String toolClass, @Nullable EntityPlayer player, @Nullable IBlockState blockState) {
        if (!stack.isItemEnchanted()) {
            stack.addEnchantment(Enchantments.SILK_TOUCH, 1);
        }
        return super.getHarvestLevel(stack, toolClass, player, blockState);
    }

    public boolean isRepairable() {
        return false;
    }

    public void onCreated(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        if (!stack.isItemEnchanted()) {
            stack.addEnchantment(Enchantments.SILK_TOUCH, 1);
        }
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - ItemUtils.getPowerForDurabilityBar((ItemStack)stack);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return PowerSystem.getDisplayPower().colour;
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new PoweredItemContainerProvider(stack);
    }

    public boolean shouldCauseBlockBreakReset(ItemStack oldStack, ItemStack newStack) {
        return !newStack.isItemEqual(oldStack);
    }

    @SideOnly(value=Side.CLIENT)
    public void getSubItems(CreativeTabs par2CreativeTabs, NonNullList<ItemStack> itemList) {
        if (!this.isInCreativeTab(par2CreativeTabs)) {
            return;
        }
        ItemStack uncharged = new ItemStack(ModItems.ROCK_CUTTER);
        uncharged.addEnchantment(Enchantments.SILK_TOUCH, 1);
        ItemStack charged = new ItemStack(ModItems.ROCK_CUTTER);
        charged.addEnchantment(Enchantments.SILK_TOUCH, 1);
        ForgePowerItemManager capEnergy = new ForgePowerItemManager(charged);
        capEnergy.setEnergyStored(capEnergy.getMaxEnergyStored());
        itemList.add((Object)uncharged);
        itemList.add((Object)charged);
    }

    public double getMaxPower(ItemStack stack) {
        return maxCharge;
    }

    public boolean canAcceptEnergy(ItemStack stack) {
        return true;
    }

    public boolean canProvideEnergy(ItemStack stack) {
        return false;
    }

    public double getMaxTransfer(ItemStack stack) {
        return 1000.0;
    }
}

