/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import reborncore.api.IToolDrop;
import reborncore.common.util.ChatUtils;
import techreborn.blocks.BlockAlarm;
import techreborn.init.ModBlocks;
import techreborn.init.ModSounds;
import techreborn.lib.MessageIDs;

public class TileAlarm
extends TileEntity
implements ITickable,
IToolDrop {
    private int selectedSound = 1;

    public void rightClick() {
        if (!this.world.isRemote) {
            this.selectedSound = this.selectedSound < 3 ? ++this.selectedSound : 1;
            ChatUtils.sendNoSpamMessages((int)MessageIDs.alarmID, (ITextComponent)new TextComponentString(TextFormatting.GRAY + I18n.format((String)"techreborn.message.alarm", (Object[])new Object[0]) + " Alarm " + this.selectedSound));
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound compound) {
        if (compound == null) {
            compound = new NBTTagCompound();
        }
        compound.setInteger("selectedSound", this.selectedSound);
        return super.writeToNBT(compound);
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (compound != null && compound.hasKey("selectedSound")) {
            this.selectedSound = compound.getInteger("selectedSound");
        }
        super.readFromNBT(compound);
    }

    public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
        return false;
    }

    public void update() {
        if (!this.world.isRemote && this.world.getTotalWorldTime() % 25L == 0L && this.world.isBlockPowered(this.getPos())) {
            BlockAlarm.setActive(true, this.world, this.pos);
            switch (this.selectedSound) {
                case 1: {
                    this.world.playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), ModSounds.ALARM, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    break;
                }
                case 2: {
                    this.world.playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), ModSounds.ALARM_2, SoundCategory.BLOCKS, 4.0f, 1.0f);
                    break;
                }
                case 3: {
                    this.world.playSound(null, (double)this.pos.getX(), (double)this.pos.getY(), (double)this.pos.getZ(), ModSounds.ALARM_3, SoundCategory.BLOCKS, 4.0f, 1.0f);
                }
            }
        } else if (!this.world.isRemote && this.world.getTotalWorldTime() % 25L == 0L) {
            BlockAlarm.setActive(false, this.world, this.pos);
        }
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.ALARM, 1);
    }
}

