/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.util.Inventory;

public abstract class TileGenericMachine
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IRecipeCrafterProvider {
    public String name;
    public int maxInput;
    public int maxEnergy;
    public Block toolDrop;
    public int energySlot;
    public Inventory inventory;
    public RecipeCrafter crafter;

    public TileGenericMachine(String name, int maxInput, int maxEnergy, Block toolDrop, int energySlot) {
        this.name = "Tile" + name;
        this.maxInput = maxInput;
        this.maxEnergy = maxEnergy;
        this.toolDrop = toolDrop;
        this.energySlot = energySlot;
        this.checkTeir();
    }

    public int getProgressScaled(int scale) {
        if (this.crafter != null && this.crafter.currentTickTime != 0) {
            return this.crafter.currentTickTime * scale / this.crafter.currentNeededTicks;
        }
        return 0;
    }

    public void update() {
        super.update();
        if (!this.world.isRemote) {
            this.charge(this.energySlot);
        }
    }

    public double getBaseMaxPower() {
        return this.maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return true;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return false;
    }

    public double getBaseMaxOutput() {
        return 0.0;
    }

    public double getBaseMaxInput() {
        return this.maxInput;
    }

    public ItemStack getToolDrop(EntityPlayer p0) {
        return new ItemStack(this.toolDrop, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public RecipeCrafter getRecipeCrafter() {
        return this.crafter;
    }
}

