/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import reborncore.api.IListInfoProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.recipes.RecipeCrafter;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import techreborn.api.Reference;
import techreborn.init.ModBlocks;
import techreborn.items.DynamicCell;
import techreborn.tiles.TileGenericMachine;

@RebornRegistry(modID="techreborn")
public class TileIndustrialCentrifuge
extends TileGenericMachine
implements IContainerProvider,
IListInfoProvider {
    @ConfigRegistry(config="machines", category="centrifuge", key="CentrifugeMaxInput", comment="Centrifuge Max Input (Value in EU)")
    public static int maxInput = 32;
    @ConfigRegistry(config="machines", category="centrifuge", key="CentrifugeMaxEnergy", comment="Centrifuge Max Energy (Value in EU)")
    public static int maxEnergy = 10000;

    public TileIndustrialCentrifuge() {
        super("IndustrialCentrifuge", maxInput, maxEnergy, ModBlocks.INDUSTRIAL_CENTRIFUGE, 6);
        int[] inputs = new int[]{0, 1};
        int[] outputs = new int[]{2, 3, 4, 5};
        this.inventory = new Inventory(7, "TileIndustrialCentrifuge", 64, (TileEntity)this);
        this.crafter = new RecipeCrafter(Reference.CENTRIFUGE_RECIPE, (TileEntity)this, 2, 4, this.inventory, inputs, outputs);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("centrifuge").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).filterSlot(1, 40, 54, stack -> ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true)).filterSlot(0, 40, 34, stack -> !ItemUtils.isItemEqual((ItemStack)stack, (ItemStack)DynamicCell.getEmptyCell(1), (boolean)true, (boolean)true)).outputSlot(2, 82, 44).outputSlot(3, 101, 25).outputSlot(4, 120, 44).outputSlot(5, 101, 63).energySlot(6, 8, 72).syncEnergyValue().syncCrafterValue().addInventory().create((TileLegacyMachineBase)this);
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        super.addInfo(info, isRealTile);
        info.add("Round and round it goes");
    }
}

