/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.capability.IFluidHandler;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.FluidUtils;
import reborncore.common.util.Inventory;
import reborncore.common.util.Tank;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileQuantumTank
extends TileLegacyMachineBase
implements IInventoryProvider,
IToolDrop,
IListInfoProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="quantum_tank", key="QuantumTankMaxStorage", comment="Maximum amount of millibuckets a Quantum Tank can store")
    public static int maxStorage = Integer.MAX_VALUE;
    public Tank tank = new Tank("TileQuantumTank", maxStorage, (TileLegacyMachineBase)this);
    public Inventory inventory = new Inventory(3, "TileQuantumTank", 64, (TileEntity)this);

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.tank.writeToNBT(tagCompound);
        return tagCompound;
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(ModBlocks.QUANTUM_TANK, 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.setTagCompound(new NBTTagCompound());
        dropStack.getTagCompound().setTag("tileEntity", (NBTBase)tileEntity);
        return dropStack;
    }

    public void update() {
        super.update();
        if (!this.world.isRemote && (FluidUtils.drainContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1) || FluidUtils.fillContainers((IFluidHandler)this.tank, (IInventory)this.inventory, (int)0, (int)1, (Fluid)this.tank.getFluidType()))) {
            this.syncWithAll();
        }
        this.tank.compareAndUpdate();
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.pos.getX(), this.pos.getY(), this.pos.getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            if (this.tank.getFluid() != null) {
                info.add(this.tank.getFluidAmount() + " of " + this.tank.getFluidType().getName());
            } else {
                info.add("Empty");
            }
        }
        info.add("Capacity " + this.tank.getCapacity() + " mb");
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("quantumtank").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).fluidSlot(0, 80, 17).outputSlot(1, 80, 53).addInventory().create((TileLegacyMachineBase)this);
    }

    @Nullable
    public Tank getTank() {
        return this.tank;
    }
}

