/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import powercrystals.minefactoryreloaded.api.IDeepStorageUnit;
import reborncore.api.IListInfoProvider;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;

public class TileTechStorageBase
extends TileLegacyMachineBase
implements IInventoryProvider,
IToolDrop,
IListInfoProvider,
IDeepStorageUnit {
    public final int maxCapacity;
    public final Inventory inventory;
    public InvWrapper invWrapper;
    public ItemStack storedItem;

    public TileTechStorageBase(String name, int maxCapacity) {
        this.maxCapacity = maxCapacity;
        this.storedItem = ItemStack.EMPTY;
        this.inventory = new Inventory(3, name, maxCapacity, (TileEntity)this);
    }

    public void readFromNBTWithoutCoords(NBTTagCompound tagCompound) {
        this.storedItem = ItemStack.EMPTY;
        if (tagCompound.hasKey("storedStack")) {
            this.storedItem = new ItemStack((NBTTagCompound)tagCompound.getTag("storedStack"));
        }
        if (!this.storedItem.isEmpty()) {
            this.storedItem.setCount(Math.min(tagCompound.getInteger("storedQuantity"), this.maxCapacity));
        }
        this.inventory.readFromNBT(tagCompound);
    }

    public NBTTagCompound writeToNBTWithoutCoords(NBTTagCompound tagCompound) {
        if (!this.storedItem.isEmpty()) {
            ItemStack temp = this.storedItem.copy();
            if (this.storedItem.getCount() > this.storedItem.getMaxStackSize()) {
                temp.setCount(this.storedItem.getMaxStackSize());
            }
            tagCompound.setTag("storedStack", (NBTBase)temp.writeToNBT(new NBTTagCompound()));
            tagCompound.setInteger("storedQuantity", Math.min(this.storedItem.getCount(), this.maxCapacity));
        } else {
            tagCompound.setInteger("storedQuantity", 0);
        }
        this.inventory.writeToNBT(tagCompound);
        return tagCompound;
    }

    public ItemStack getDropWithNBT() {
        NBTTagCompound tileEntity = new NBTTagCompound();
        ItemStack dropStack = new ItemStack(this.getBlockType(), 1);
        this.writeToNBTWithoutCoords(tileEntity);
        dropStack.setTagCompound(new NBTTagCompound());
        dropStack.getTagCompound().setTag("tileEntity", (NBTBase)tileEntity);
        this.storedItem.setCount(0);
        this.setInventorySlotContents(1, ItemStack.EMPTY);
        this.syncWithAll();
        return dropStack;
    }

    public InvWrapper getInvWrapper() {
        if (this.invWrapper == null) {
            this.invWrapper = new InvWrapper((IInventory)this);
        }
        return this.invWrapper;
    }

    public int getStoredCount() {
        return this.storedItem.getCount();
    }

    public List<ItemStack> getContentDrops() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        if (!this.getStoredItemType().isEmpty()) {
            if (!this.getStackInSlot(1).isEmpty()) {
                stacks.add(this.getStackInSlot(1));
            }
            int size = this.storedItem.getMaxStackSize();
            for (int i = 0; i < this.getStoredCount() / size; ++i) {
                ItemStack droped = this.storedItem.copy();
                droped.setCount(size);
                stacks.add(droped);
            }
            if (this.getStoredCount() % size != 0) {
                ItemStack droped = this.storedItem.copy();
                droped.setCount(this.getStoredCount() % size);
                stacks.add(droped);
            }
        }
        return stacks;
    }

    public void update() {
        super.update();
        if (!this.world.isRemote) {
            ItemStack outputStack = ItemStack.EMPTY;
            if (!this.getStackInSlot(1).isEmpty()) {
                outputStack = this.getStackInSlot(1);
            }
            if (!this.getStackInSlot(0).isEmpty() && this.storedItem.getCount() + outputStack.getCount() < this.maxCapacity) {
                ItemStack inputStack = this.getStackInSlot(0);
                if (this.getStoredItemType().isEmpty() || this.storedItem.isEmpty() && ItemUtils.isItemEqual((ItemStack)inputStack, (ItemStack)outputStack, (boolean)true, (boolean)true)) {
                    this.storedItem = inputStack;
                    this.setInventorySlotContents(0, ItemStack.EMPTY);
                } else if (ItemUtils.isItemEqual((ItemStack)this.getStoredItemType(), (ItemStack)inputStack, (boolean)true, (boolean)true)) {
                    int reminder = this.maxCapacity - this.storedItem.getCount() - outputStack.getCount();
                    if (inputStack.getCount() <= reminder) {
                        this.setStoredItemCount(inputStack.getCount());
                        this.setInventorySlotContents(0, ItemStack.EMPTY);
                    } else {
                        this.setStoredItemCount(this.maxCapacity - outputStack.getCount());
                        this.getStackInSlot(0).shrink(reminder);
                    }
                }
                this.markDirty();
                this.syncWithAll();
            }
            if (!this.storedItem.isEmpty()) {
                if (outputStack.isEmpty()) {
                    ItemStack delivered = this.storedItem.copy();
                    delivered.setCount(Math.min(this.storedItem.getCount(), delivered.getMaxStackSize()));
                    this.storedItem.shrink(delivered.getCount());
                    if (this.storedItem.isEmpty()) {
                        this.storedItem = ItemStack.EMPTY;
                    }
                    this.setInventorySlotContents(1, delivered);
                    this.markDirty();
                    this.syncWithAll();
                } else if (ItemUtils.isItemEqual((ItemStack)this.storedItem, (ItemStack)outputStack, (boolean)true, (boolean)true) && outputStack.getCount() < outputStack.getMaxStackSize()) {
                    int wanted = Math.min(this.storedItem.getCount(), outputStack.getMaxStackSize() - outputStack.getCount());
                    outputStack.setCount(outputStack.getCount() + wanted);
                    this.storedItem.shrink(wanted);
                    if (this.storedItem.isEmpty()) {
                        this.storedItem = ItemStack.EMPTY;
                    }
                    this.markDirty();
                    this.syncWithAll();
                }
            }
        }
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity packet) {
        this.world.markBlockRangeForRenderUpdate(this.pos.getX(), this.pos.getY(), this.pos.getZ(), this.pos.getX(), this.pos.getY(), this.pos.getZ());
        this.readFromNBT(packet.getNbtCompound());
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.readFromNBTWithoutCoords(tagCompound);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        this.writeToNBTWithoutCoords(tagCompound);
        return tagCompound;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.getInvWrapper());
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return this.getDropWithNBT();
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        if (isRealTile) {
            int size = 0;
            String name = "of nothing";
            if (!this.storedItem.isEmpty()) {
                name = this.storedItem.getDisplayName();
                size += this.storedItem.getCount();
            }
            if (!this.getStackInSlot(1).isEmpty()) {
                name = this.getStackInSlot(1).getDisplayName();
                size += this.getStackInSlot(1).getCount();
            }
            info.add(size + " " + name);
        }
    }

    public ItemStack getStoredItemType() {
        return this.storedItem.isEmpty() ? this.getStackInSlot(1) : this.storedItem;
    }

    public void setStoredItemCount(int amount) {
        this.storedItem.grow(amount);
        this.markDirty();
    }

    public void setStoredItemType(ItemStack type, int amount) {
        this.storedItem = type;
        this.storedItem.setCount(amount);
        this.markDirty();
    }

    public int getMaxStoredCount() {
        return this.maxCapacity;
    }
}

