/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.fusionReactor;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.RebornCoreConfig;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import reborncore.common.util.ItemUtils;
import reborncore.common.util.Torus;
import techreborn.api.reactor.FusionReactorRecipe;
import techreborn.api.reactor.FusionReactorRecipeHelper;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileFusionControlComputer
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="machines", category="fusion_reactor", key="FusionReactorMaxInput", comment="Fusion Reactor Max Input (Value in EU)")
    public static int maxInput = 8192;
    @ConfigRegistry(config="machines", category="fusion_reactor", key="FusionReactorMaxOutput", comment="Fusion Reactor Max Output (Value in EU)")
    public static int maxOutput = 1000000;
    @ConfigRegistry(config="machines", category="fusion_reactor", key="FusionReactorMaxEnergy", comment="Fusion Reactor Max Energy (Value in EU)")
    public static int maxEnergy = 100000000;
    @ConfigRegistry(config="machines", category="fusion_reactor", key="FusionReactorMaxCoilSize", comment="Fusion Reactor Max Coil size (Radius)")
    public static int maxCoilSize = 50;
    public Inventory inventory;
    public int coilCount = 0;
    public int crafingTickTime = 0;
    public int finalTickTime = 0;
    public int neededPower = 0;
    public int size = 6;
    public int state = -1;
    int topStackSlot = 0;
    int bottomStackSlot = 1;
    int outputStackSlot = 2;
    FusionReactorRecipe currentRecipe = null;
    boolean hasStartedCrafting = false;

    public TileFusionControlComputer() {
        this.checkOverfill = false;
        this.inventory = new Inventory(3, "TileFusionControlComputer", 64, (TileEntity)this);
    }

    public boolean checkCoils() {
        List coils = Torus.generate((BlockPos)this.pos, (int)this.size);
        for (BlockPos coilPos : coils) {
            if (this.isCoil(coilPos)) continue;
            this.coilCount = 0;
            return false;
        }
        this.coilCount = coils.size();
        return true;
    }

    public boolean isCoil(BlockPos pos) {
        return this.world.getBlockState(pos).getBlock() == ModBlocks.FUSION_COIL;
    }

    private void resetCrafter() {
        this.currentRecipe = null;
        this.crafingTickTime = 0;
        this.finalTickTime = 0;
        this.neededPower = 0;
        this.hasStartedCrafting = false;
    }

    public boolean canFitStack(ItemStack stack, int slot, boolean oreDic) {
        if (stack.isEmpty()) {
            return true;
        }
        if (this.inventory.getStackInSlot(slot).isEmpty()) {
            return true;
        }
        return ItemUtils.isItemEqual((ItemStack)this.inventory.getStackInSlot(slot), (ItemStack)stack, (boolean)true, (boolean)true, (boolean)oreDic) && stack.getCount() + this.inventory.getStackInSlot(slot).getCount() <= stack.getMaxStackSize();
    }

    public int getProgressScaled(int scale) {
        if (this.crafingTickTime != 0 && this.finalTickTime != 0) {
            return this.crafingTickTime * scale / this.finalTickTime;
        }
        return 0;
    }

    private void updateCurrentRecipe() {
        for (FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
            if (!this.validateReactorRecipe(reactorRecipe)) continue;
            this.currentRecipe = reactorRecipe;
            this.crafingTickTime = 0;
            this.finalTickTime = this.currentRecipe.getTickTime();
            this.neededPower = (int)this.currentRecipe.getStartEU();
            this.hasStartedCrafting = false;
            break;
        }
    }

    private boolean validateReactorRecipe(FusionReactorRecipe recipe) {
        return this.validateReactorRecipeInputs(recipe, this.getStackInSlot(this.topStackSlot), this.getStackInSlot(this.bottomStackSlot)) || this.validateReactorRecipeInputs(recipe, this.getStackInSlot(this.bottomStackSlot), this.getStackInSlot(this.topStackSlot));
    }

    private boolean validateReactorRecipeInputs(FusionReactorRecipe recipe, ItemStack slot1, ItemStack slot2) {
        if (ItemUtils.isItemEqual((ItemStack)slot1, (ItemStack)recipe.getTopInput(), (boolean)true, (boolean)true, (boolean)true)) {
            if (recipe.getBottomInput() != null && !ItemUtils.isItemEqual((ItemStack)slot2, (ItemStack)recipe.getBottomInput(), (boolean)true, (boolean)true, (boolean)true)) {
                return false;
            }
            if (this.canFitStack(recipe.getOutput(), this.outputStackSlot, true)) {
                return true;
            }
        }
        return false;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        if (this.world.getTotalWorldTime() % 20L == 0L) {
            this.checkCoils();
            this.inventory.hasChanged = true;
        }
        if (this.coilCount == 0) {
            this.resetCrafter();
            return;
        }
        if (this.currentRecipe == null && this.inventory.hasChanged) {
            this.updateCurrentRecipe();
        }
        if (this.currentRecipe != null) {
            if (!this.hasStartedCrafting && this.inventory.hasChanged && !this.validateReactorRecipe(this.currentRecipe)) {
                this.resetCrafter();
                return;
            }
            if (!this.hasStartedCrafting && this.canUseEnergy(this.currentRecipe.getStartEU())) {
                this.useEnergy(this.currentRecipe.getStartEU());
                this.hasStartedCrafting = true;
                this.decrStackSize(this.topStackSlot, this.currentRecipe.getTopInput().getCount());
                if (!this.currentRecipe.getBottomInput().isEmpty()) {
                    this.decrStackSize(this.bottomStackSlot, this.currentRecipe.getBottomInput().getCount());
                }
            }
            if (this.hasStartedCrafting && this.crafingTickTime < this.finalTickTime) {
                ++this.crafingTickTime;
                if (this.currentRecipe.getEuTick() > 0.0) {
                    this.addEnergy(this.currentRecipe.getEuTick() * this.getPowerMultiplier());
                    this.powerChange = this.currentRecipe.getEuTick() * this.getPowerMultiplier();
                } else if (this.canUseEnergy(this.currentRecipe.getEuTick() * -1.0)) {
                    this.setEnergy(this.getEnergy() - this.currentRecipe.getEuTick() * -1.0);
                }
            } else if (this.crafingTickTime >= this.finalTickTime && this.canFitStack(this.currentRecipe.getOutput(), this.outputStackSlot, true)) {
                if (this.getStackInSlot(this.outputStackSlot).isEmpty()) {
                    this.setInventorySlotContents(this.outputStackSlot, this.currentRecipe.getOutput().copy());
                } else {
                    this.decrStackSize(this.outputStackSlot, -this.currentRecipe.getOutput().getCount());
                }
                if (this.validateReactorRecipe(this.currentRecipe)) {
                    this.crafingTickTime = 0;
                    this.decrStackSize(this.topStackSlot, this.currentRecipe.getTopInput().getCount());
                    if (!this.currentRecipe.getBottomInput().isEmpty()) {
                        this.decrStackSize(this.bottomStackSlot, this.currentRecipe.getBottomInput().getCount());
                    }
                } else {
                    this.resetCrafter();
                }
            }
            this.markDirty();
        }
        if (this.inventory.hasChanged) {
            this.inventory.hasChanged = false;
        }
    }

    public double getPowerMultiplier() {
        double calc = 0.5 * Math.pow(this.size - 5, 1.8);
        return Math.max((double)Math.round(calc * 100.0) / 100.0, 1.0);
    }

    public double getBaseMaxPower() {
        return Math.min((double)maxEnergy * this.getPowerMultiplier(), (double)(Integer.MAX_VALUE / RebornCoreConfig.euPerFU));
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return direction != EnumFacing.DOWN && direction != EnumFacing.UP;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return direction == EnumFacing.DOWN || direction == EnumFacing.UP;
    }

    public double getBaseMaxOutput() {
        if (!this.hasStartedCrafting) {
            return 0.0;
        }
        return Integer.MAX_VALUE / RebornCoreConfig.euPerFU;
    }

    public double getBaseMaxInput() {
        if (this.hasStartedCrafting) {
            return 0.0;
        }
        return maxInput;
    }

    public void readFromNBT(NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.crafingTickTime = tagCompound.getInteger("crafingTickTime");
        this.finalTickTime = tagCompound.getInteger("finalTickTime");
        this.neededPower = tagCompound.getInteger("neededPower");
        this.hasStartedCrafting = tagCompound.getBoolean("hasStartedCrafting");
        if (tagCompound.hasKey("hasActiveRecipe") && tagCompound.getBoolean("hasActiveRecipe") && this.currentRecipe == null) {
            for (FusionReactorRecipe reactorRecipe : FusionReactorRecipeHelper.reactorRecipes) {
                if (!this.validateReactorRecipe(reactorRecipe)) continue;
                this.currentRecipe = reactorRecipe;
            }
        }
        if (tagCompound.hasKey("size")) {
            this.size = tagCompound.getInteger("size");
        }
        this.size = Math.min(this.size, maxCoilSize);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.setInteger("crafingTickTime", this.crafingTickTime);
        tagCompound.setInteger("finalTickTime", this.finalTickTime);
        tagCompound.setInteger("neededPower", this.neededPower);
        tagCompound.setBoolean("hasStartedCrafting", this.hasStartedCrafting);
        tagCompound.setBoolean("hasActiveRecipe", this.currentRecipe != null);
        tagCompound.setInteger("size", this.size);
        return tagCompound;
    }

    public void onLoad() {
        super.onLoad();
        this.checkCoils();
    }

    public boolean canBeUpgraded() {
        return false;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.FUSION_CONTROL_COMPUTER, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("fusionreactor").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 34, 47).slot(1, 126, 47).outputSlot(2, 80, 47).syncEnergyValue().syncIntegerValue(this::getCoilStatus, this::setCoilStatus).syncIntegerValue(this::getCrafingTickTime, this::setCrafingTickTime).syncIntegerValue(this::getFinalTickTime, this::setFinalTickTime).syncIntegerValue(this::getSize, this::setSize).syncIntegerValue(this::getState, this::setState).syncIntegerValue(this::getNeededPower, this::setNeededPower).addInventory().create((TileLegacyMachineBase)this);
    }

    public int getCoilStatus() {
        return this.coilCount;
    }

    public void setCoilStatus(int coilStatus) {
        this.coilCount = coilStatus;
    }

    public int getCrafingTickTime() {
        return this.crafingTickTime;
    }

    public void setCrafingTickTime(int crafingTickTime) {
        this.crafingTickTime = crafingTickTime;
    }

    public int getFinalTickTime() {
        return this.finalTickTime;
    }

    public void setFinalTickTime(int finalTickTime) {
        this.finalTickTime = finalTickTime;
    }

    public int getNeededPower() {
        return this.neededPower;
    }

    public void setNeededPower(int neededPower) {
        this.neededPower = neededPower;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public void changeSize(int sizeDelta) {
        int newSize = this.size + sizeDelta;
        this.size = Math.max(6, Math.min(maxCoilSize, newSize));
    }

    public int getState() {
        if (this.currentRecipe == null) {
            return 0;
        }
        if (!this.hasStartedCrafting) {
            return 1;
        }
        if (this.hasStartedCrafting) {
            return 2;
        }
        return -1;
    }

    public void setState(int state) {
        this.state = state;
    }

    public String getStateString() {
        if (this.state == -1) {
            return "";
        }
        if (this.state == 0) {
            return "No recipe";
        }
        if (this.state == 1) {
            return "Charging";
        }
        if (this.state == 2) {
            return "Crafting";
        }
        return "";
    }
}

