/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileDragonEggSyphon
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider {
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerMaxOutput", comment="Dragon Egg Siphoner Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerMaxEnergy", comment="Dragon Egg Siphoner Max Energy (Value in EU)")
    public static int maxEnergy = 1000;
    @ConfigRegistry(config="generators", category="dragon_egg_siphoner", key="DragonEggSiphonerEnergyPerTick", comment="Dragon Egg Siphoner Energy Per Tick (Value in EU)")
    public static int energyPerTick = 4;
    public Inventory inventory = new Inventory(3, "TileDragonEggSyphon", 64, (TileEntity)this);
    private long lastOutput = 0L;

    private boolean tryAddingEnergy(int amount) {
        if (this.getMaxPower() - this.getEnergy() >= (double)amount) {
            this.addEnergy(amount);
            return true;
        }
        if (this.getMaxPower() - this.getEnergy() > 0.0) {
            this.addEnergy(this.getMaxPower() - this.getEnergy());
            return true;
        }
        return false;
    }

    public void update() {
        super.update();
        if (!this.world.isRemote) {
            if (this.world.getBlockState(new BlockPos(this.pos.getX(), this.pos.getY() + 1, this.pos.getZ())).getBlock() == Blocks.DRAGON_EGG && this.tryAddingEnergy(energyPerTick)) {
                this.lastOutput = this.world.getTotalWorldTime();
            }
            if (this.world.getTotalWorldTime() - this.lastOutput < 30L && !this.isActive()) {
                this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(true)));
            } else if (this.world.getTotalWorldTime() - this.lastOutput > 30L && this.isActive()) {
                this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)BlockMachineBase.ACTIVE, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.DRAGON_EGG_SYPHON, 1);
    }

    public Inventory getInventory() {
        return this.inventory;
    }
}

