/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.api.generator.EFluidGenerator;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileBaseFluidGenerator;

@RebornRegistry(modID="techreborn")
public class TileGasTurbine
extends TileBaseFluidGenerator
implements IContainerProvider {
    @ConfigRegistry(config="generators", category="gas_generator", key="GasGeneratorMaxOutput", comment="Gas Generator Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="gas_generator", key="GasGeneratorMaxEnergy", comment="Gas Generator Max Energy (Value in EU)")
    public static int maxEnergy = 1000000;
    @ConfigRegistry(config="generators", category="gas_generator", key="GasGeneratorTankCapacity", comment="Gas Generator Tank Capacity")
    public static int tankCapacity = 10000;
    @ConfigRegistry(config="generators", category="gas_generator", key="GasGeneratorEnergyPerTick", comment="Gas Generator Energy Per Tick (Value in EU)")
    public static int energyPerTick = 16;

    public TileGasTurbine() {
        super(EFluidGenerator.GAS, "TileGasTurbine", tankCapacity, energyPerTick);
    }

    public ItemStack getToolDrop(EntityPlayer entityPlayer) {
        return new ItemStack(ModBlocks.GAS_TURBINE, 1);
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("gasturbine").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 25, 35).outputSlot(1, 25, 55).syncEnergyValue().syncIntegerValue(this::getTicksSinceLastChange, this::setTicksSinceLastChange).syncIntegerValue(this::getTankAmount, this::setTankAmount).addInventory().create((TileLegacyMachineBase)this);
    }
}

