/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import techreborn.api.generator.EFluidGenerator;
import techreborn.init.ModBlocks;
import techreborn.tiles.generator.TileBaseFluidGenerator;

@RebornRegistry(modID="techreborn")
public class TilePlasmaGenerator
extends TileBaseFluidGenerator
implements IContainerProvider {
    @ConfigRegistry(config="generators", category="plasma_generator", key="PlasmaGeneratorMaxOutput", comment="Plasma Generator Max Output (Value in EU)")
    public static int maxOutput = 2048;
    @ConfigRegistry(config="generators", category="plasma_generator", key="PlasmaGeneratorMaxEnergy", comment="Plasma Generator Max Energy (Value in EU)")
    public static double maxEnergy = 5.0E8;
    @ConfigRegistry(config="generators", category="plasma_generator", key="PlasmaGeneratorTankCapacity", comment="Plasma Generator Tank Capacity")
    public static int tankCapacity = 10000;
    @ConfigRegistry(config="generators", category="plasma_generator", key="PlasmaGeneratorEnergyPerTick", comment="Plasma Generator Energy Per Tick (Value in EU)")
    public static int energyPerTick = 400;

    public TilePlasmaGenerator() {
        super(EFluidGenerator.PLASMA, "TilePlasmaGenerator", tankCapacity, energyPerTick);
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.PLASMA_GENERATOR, 1);
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    @Override
    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("plasmagenerator").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).slot(0, 25, 35).outputSlot(1, 25, 55).syncEnergyValue().syncIntegerValue(this::getTicksSinceLastChange, this::setTicksSinceLastChange).syncIntegerValue(this::getTankAmount, this::setTankAmount).addInventory().create((TileLegacyMachineBase)this);
    }
}

