/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.text.TextFormatting;
import reborncore.api.IToolDrop;
import reborncore.api.power.EnumPowerTier;
import reborncore.common.powerSystem.PowerSystem;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.util.StringUtils;
import techreborn.Core;
import techreborn.blocks.generator.solarpanel.BlockSolarPanel;
import techreborn.blocks.generator.solarpanel.EnumPanelType;
import techreborn.init.ModBlocks;

public class TileSolarPanel
extends TilePowerAcceptor
implements IToolDrop {
    boolean canSeeSky = false;
    boolean lastSate = false;
    int powerToAdd;
    EnumPanelType panel;

    public TileSolarPanel() {
    }

    public TileSolarPanel(EnumPanelType panel) {
        this.panel = panel;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        if (this.world.getTotalWorldTime() % 20L == 0L) {
            this.canSeeSky = this.world.canBlockSeeSky(this.pos.up());
            if (this.lastSate != this.isSunOut()) {
                this.world.setBlockState(this.pos, this.world.getBlockState(this.pos).withProperty((IProperty)BlockSolarPanel.ACTIVE, (Comparable)Boolean.valueOf(this.isSunOut())));
                this.lastSate = this.isSunOut();
            }
        }
        this.powerToAdd = this.isSunOut() ? this.panel.generationRateD : (this.canSeeSky ? this.panel.generationRateN : 0);
        this.addEnergy(this.powerToAdd);
    }

    public boolean isSunOut() {
        return this.canSeeSky && !this.world.isRaining() && !this.world.isThundering() && this.world.isDaytime();
    }

    public double getBaseMaxPower() {
        return this.panel.internalCapacity;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return this.panel.generationRateD;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public EnumPowerTier getTier() {
        return this.panel.powerTier;
    }

    public EnumPowerTier getBaseTier() {
        return this.getTier();
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.SOLAR_PANEL, 1, this.panel.ordinal());
    }

    public void rotate(Rotation rotationIn) {
    }

    public void readFromNBT(NBTTagCompound tag) {
        if (tag.hasKey("panelType")) {
            this.panel = EnumPanelType.values()[tag.getInteger("panelType")];
        } else {
            Core.logHelper.warn((Object)("A solar panel has failed to load from NBT, it will not work correctly. Please break and replace it to fix the issue. BlockPos:" + this.pos.toString()));
            this.panel = EnumPanelType.Basic;
        }
        super.readFromNBT(tag);
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.setInteger("panelType", this.panel.ordinal());
        return super.writeToNBT(tag);
    }

    public void checkTeir() {
    }

    public void addInfo(List<String> info, boolean isRealTile) {
        info.add(TextFormatting.GRAY + "Internal Energy Storage: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)((int)this.getMaxPower())));
        info.add(TextFormatting.GRAY + "Generation Rate Day: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)this.panel.generationRateD));
        info.add(TextFormatting.GRAY + "Generation Rate Night: " + TextFormatting.GOLD + PowerSystem.getLocaliszedPowerFormatted((int)this.panel.generationRateN));
        info.add(TextFormatting.GRAY + "Tier: " + TextFormatting.GOLD + StringUtils.toFirstCapitalAllLowercase((String)this.getTier().toString()));
    }
}

