/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.ForgeModContainer;
import reborncore.api.IToolDrop;
import reborncore.api.tile.IInventoryProvider;
import reborncore.client.containerBuilder.IContainerProvider;
import reborncore.client.containerBuilder.builder.BuiltContainer;
import reborncore.client.containerBuilder.builder.ContainerBuilder;
import reborncore.common.blocks.BlockMachineBase;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import reborncore.common.tile.TileLegacyMachineBase;
import reborncore.common.util.Inventory;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileSolidFuelGenerator
extends TilePowerAcceptor
implements IToolDrop,
IInventoryProvider,
IContainerProvider {
    @ConfigRegistry(config="generators", category="generator", key="GeneratorMaxOutput", comment="Solid Fuel Generator Max Output (Value in EU)")
    public static int maxOutput = 32;
    @ConfigRegistry(config="generators", category="generator", key="GeneratorMaxEnergy", comment="Solid Fuel Generator Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    @ConfigRegistry(config="generators", category="generator", key="GeneratorEnergyOutput", comment="Solid Fuel Generator Energy Output Amount (Value in EU)")
    public static int outputAmount = 10;
    public Inventory inventory = new Inventory(2, "TileSolidFuelGenerator", 64, (TileEntity)this);
    public int fuelSlot = 0;
    public int burnTime;
    public int totalBurnTime = 0;
    public boolean isBurning;
    public boolean lastTickBurning;
    ItemStack burnItem;

    public static int getItemBurnTime(ItemStack stack) {
        return TileEntityFurnace.getItemBurnTime((ItemStack)stack) / 4;
    }

    public void update() {
        super.update();
        if (this.world.isRemote) {
            return;
        }
        if (this.getEnergy() < this.getMaxPower()) {
            if (this.burnTime > 0) {
                --this.burnTime;
                this.addEnergy(outputAmount);
                this.isBurning = true;
            }
        } else {
            this.isBurning = false;
        }
        if (this.burnTime == 0) {
            this.updateState();
            this.burnTime = this.totalBurnTime = TileSolidFuelGenerator.getItemBurnTime(this.getStackInSlot(this.fuelSlot));
            if (this.burnTime > 0) {
                this.updateState();
                this.burnItem = this.getStackInSlot(this.fuelSlot);
                if (this.getStackInSlot(this.fuelSlot).getCount() == 1) {
                    if (this.getStackInSlot(this.fuelSlot).getItem() == Items.LAVA_BUCKET || this.getStackInSlot(this.fuelSlot).getItem() == ForgeModContainer.getInstance().universalBucket) {
                        this.setInventorySlotContents(this.fuelSlot, new ItemStack(Items.BUCKET));
                    } else {
                        this.setInventorySlotContents(this.fuelSlot, ItemStack.EMPTY);
                    }
                } else {
                    this.decrStackSize(this.fuelSlot, 1);
                }
            }
        }
        this.lastTickBurning = this.isBurning;
    }

    public void updateState() {
        IBlockState BlockStateContainer2 = this.world.getBlockState(this.pos);
        if (BlockStateContainer2.getBlock() instanceof BlockMachineBase) {
            BlockMachineBase blockMachineBase = (BlockMachineBase)BlockStateContainer2.getBlock();
            if ((Boolean)BlockStateContainer2.getValue((IProperty)BlockMachineBase.ACTIVE) != this.burnTime > 0) {
                blockMachineBase.setActive(Boolean.valueOf(this.burnTime > 0), this.world, this.pos);
            }
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.SOLID_FUEL_GENEREATOR);
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public int getScaledBurnTime(int i) {
        return (int)((float)this.burnTime / (float)this.totalBurnTime * (float)i);
    }

    public BuiltContainer createContainer(EntityPlayer player) {
        return new ContainerBuilder("generator").player(player.inventory).inventory().hotbar().addInventory().tile((IInventory)this).fuelSlot(0, 80, 54).energySlot(1, 8, 72).syncEnergyValue().syncIntegerValue(this::getBurnTime, this::setBurnTime).syncIntegerValue(this::getTotalBurnTime, this::setTotalBurnTime).addInventory().create((TileLegacyMachineBase)this);
    }

    public boolean canBeUpgraded() {
        return false;
    }
}

