/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.generator;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import reborncore.api.IToolDrop;
import reborncore.common.powerSystem.TilePowerAcceptor;
import reborncore.common.registration.RebornRegistry;
import reborncore.common.registration.impl.ConfigRegistry;
import techreborn.init.ModBlocks;

@RebornRegistry(modID="techreborn")
public class TileWindMill
extends TilePowerAcceptor
implements IToolDrop {
    @ConfigRegistry(config="generators", category="wind_mill", key="WindMillMaxOutput", comment="Wind Mill Max Output (Value in EU)")
    public static int maxOutput = 128;
    @ConfigRegistry(config="generators", category="wind_mill", key="WindMillMaxEnergy", comment="Wind Mill Max Energy (Value in EU)")
    public static int maxEnergy = 10000;
    @ConfigRegistry(config="generators", category="wind_mill", key="WindMillEnergyPerTick", comment="Wind Mill Energy Per Tick (Value in EU)")
    public static int baseEnergy = 2;
    @ConfigRegistry(config="generators", category="wind_mill", key="WindMillThunderMultiplier", comment="Wind Mill Thunder Multiplier")
    public static double thunderMultiplier = 1.25;

    public void update() {
        super.update();
        if (this.pos.getY() > 64) {
            int actualPower = baseEnergy;
            if (this.world.isThundering()) {
                actualPower = (int)((double)actualPower * thunderMultiplier);
            }
            this.addEnergy(actualPower);
        }
    }

    public double getBaseMaxPower() {
        return maxEnergy;
    }

    public boolean canAcceptEnergy(EnumFacing direction) {
        return false;
    }

    public boolean canProvideEnergy(EnumFacing direction) {
        return true;
    }

    public double getBaseMaxOutput() {
        return maxOutput;
    }

    public double getBaseMaxInput() {
        return 0.0;
    }

    public ItemStack getToolDrop(EntityPlayer playerIn) {
        return new ItemStack(ModBlocks.WIND_MILL);
    }
}

