/*
 * Decompiled with CFR 0.152.
 */
package techreborn.tiles.lesu;

import java.util.ArrayList;
import techreborn.tiles.lesu.TileLSUStorage;
import techreborn.tiles.lesu.TileLapotronicSU;

public class LesuNetwork {
    public ArrayList<TileLSUStorage> storages = new ArrayList();
    public TileLapotronicSU master;

    public void addElement(TileLSUStorage lesuStorage) {
        if (!this.storages.contains((Object)lesuStorage) && this.storages.size() < 5000) {
            this.storages.add(lesuStorage);
        }
    }

    public void removeElement(TileLSUStorage lesuStorage) {
        this.storages.remove((Object)lesuStorage);
        this.rebuild();
    }

    private void rebuild() {
        this.master = null;
        for (TileLSUStorage lesuStorage : this.storages) {
            lesuStorage.findAndJoinNetwork(lesuStorage.getWorld(), lesuStorage.getPos().getX(), lesuStorage.getPos().getY(), lesuStorage.getPos().getZ());
        }
    }

    public void merge(LesuNetwork network) {
        if (network != this) {
            ArrayList<TileLSUStorage> tileLesuStorages = new ArrayList<TileLSUStorage>();
            tileLesuStorages.addAll(network.storages);
            network.clear(false);
            for (TileLSUStorage lesuStorage : tileLesuStorages) {
                lesuStorage.setNetwork(this);
            }
            if (network.master != null && this.master == null) {
                this.master = network.master;
            }
        }
    }

    private void clear(boolean clearTiles) {
        if (clearTiles) {
            for (TileLSUStorage tileLesuStorage : this.storages) {
                tileLesuStorage.resetNetwork();
            }
        }
        this.storages.clear();
    }
}

